package kz.arta.synergy.api.rest.sample.workflow;

import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;

import java.io.*;
import java.net.HttpURLConnection;
import java.net.URL;

/**
 *
 * Класс демонстрации работы метода setWorkResult класса WorkFlowService
 * Created by root on 7/3/14.
 */
public class WorkFlowServiceSetWorkResult {

    /** Переменная логина пользователя вызывающего метод. */
    private String login;
    /** Переменная пароля пользователя вызывающего метод. */
    private String password;
    private String encoded;
    /** Переменная URL Arta Synergy. */
    private String address;
    /**
     * uuid работы.
     */
    private String workID;
    /**
     * форма завершения работы.
     */
    private String completionForm;
    private String resultID;
    private String comment;
    private String type;
    private String fileName;
    private String filePath;
    private String fileIdentifier;

    public WorkFlowServiceSetWorkResult(String login, String password, String address) {
        this.login = login;
        this.password = password;
        this.address = address;
        encoded = Base64.encode((login + ":" + password).getBytes());
    }

    public void setWorkResult() throws Exception {

        URL url = new URL(address + "/rest/api/workflow/work/set_result");
        HttpURLConnection connection = (HttpURLConnection) url.openConnection();
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Accept", "application/json; charset=utf-8");
        connection.setRequestProperty("Connection", "Keep-Alive");
        connection.setRequestProperty("Cache-Control", "no-cache");
        connection.setRequestProperty("Authorization", "Basic " + encoded);

        connection.setUseCaches(false);
        connection.setDoInput(true);
        connection.setDoOutput(true);

        DataOutputStream request = new DataOutputStream(connection.getOutputStream());
        request.writeBytes("workID=" + workID);
        request.writeBytes("&");
        request.writeBytes("completionForm=" + completionForm);

        if ("COMMENT".equals(completionForm)) {
            request.writeBytes("&");
            request.writeBytes("comment=" + comment);
        } else if ("FILE".equals(completionForm)) {

            if ("file".equals(type)) {
                request.writeBytes("&");
                request.writeBytes("type=" + type);
                request.writeBytes("&");
                request.writeBytes("file_name=" + fileName);
                request.writeBytes("&");
                request.writeBytes("file_path=" + filePath);
            } else if ("work".equals(type)) {
                request.writeBytes("&");
                request.writeBytes("type=" + type);
                request.writeBytes("&");
                request.writeBytes("file_name=" + fileName);
                request.writeBytes("&");
                request.writeBytes("file_identifier=" + fileIdentifier);
            } else {
                request.writeBytes("&");
                request.writeBytes("file_identifier=" + fileIdentifier);
            }

        } else {
            request.writeBytes("&");
            request.writeBytes("resultID=" + resultID);
        }
        request.flush();
        request.close();

        InputStream is = connection.getInputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        StringBuffer response = new StringBuffer();
        String line;
        while ((line = br.readLine()) != null) {
            response.append(line);
            response.append("\r");
        }
        br.close();
        is.close();

        JsonFactory factory = new JsonFactory();
        JsonParser parser = factory.createJsonParser(response.toString());
        JsonToken token = null;

        while ((token = parser.nextToken()) != null) {
            if (token == JsonToken.FIELD_NAME) {
                System.out.println();
                System.out.print(parser.getText() + " -> ");
                token = parser.nextToken();
                if (token == JsonToken.VALUE_STRING) {
                    System.out.print(parser.getText());
                }
            }
        }
    }

    public void setWorkID(String workID) {
        this.workID = workID;
    }

    public void setCompletionForm(String completionForm) {
        this.completionForm = completionForm;
    }

    public void setResultID(String resultID) {
        this.resultID = resultID;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public void setFileIdentifier(String fileIdentifier) {
        this.fileIdentifier = fileIdentifier;
    }

    public String getWorkID() {
        return this.workID;
    }

    public String getCompletionForm() {
        return this.completionForm;
    }

    public String getResultID() {
        return resultID;
    }

    public String getComment() {
        return comment;
    }

    public String getType() {
        return type;
    }

    public String getFileName() {
        return fileName;
    }

    public String getFilePath() {
        return filePath;
    }

    public String getFileIdentifier() {
        return fileIdentifier;
    }
}
