package kz.arta.synergy.api.rest.sample.workflow;

import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;

import java.io.*;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;

/**
 * Класс демонстрации работы метода transferWork класса WorkFlowService
 *
 * Created by root on 7/2/14.
 */
public class WorkFlowServiceTransferWork {

    /** Переменная логина пользователя вызывающего метод. */
    private String login;
    /** Переменная пароля пользователя вызывающего метод. */
    private String password;
    private String encoded;
    /** Переменная URL Arta Synergy. */
    private String address;
    /** UUID работы (FormParam). */
    private String workID;
    /** название работы. */
    private String name;
    /** uuid исполнителя работы. */
    private String userID;

    public WorkFlowServiceTransferWork(String login, String password, String address) {
        this.login = login;
        this.password = password;
        this.address = address;
        encoded = Base64.encode((login + ":" + password).getBytes());
    }

    public void transferWork() throws Exception {

        URL url = new URL(address + "/rest/api/workflow/work/transfer");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("Accept", "application/json; charset=utf-8");
        connection.setRequestProperty("Connection", "Keep-Alive");
        connection.setRequestProperty("Cache-Control", "no-cache");
        connection.setRequestProperty("Authorization", "Basic " + encoded);
        connection.setRequestMethod("POST");

        connection.setUseCaches(false);
        connection.setDoInput(true);
        connection.setDoOutput(true);

        DataOutputStream request = new DataOutputStream(connection.getOutputStream());
        request.writeBytes("workID=" + workID);
        request.writeBytes("&");
        request.writeBytes("name=" + URLEncoder.encode(name, "utf-8"));
        request.writeBytes("&");
        request.writeBytes("userID=" + userID);
        request.writeBytes("&");
        request.flush();
        request.close();

        InputStream is = connection.getInputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        StringBuffer response = new StringBuffer();
        String line;

        while ((line = br.readLine()) != null) {
            response.append(line);
            response.append("\r");
        }

        br.close();
        is.close();

        JsonFactory factory = new JsonFactory();
        JsonParser parser = factory.createJsonParser(response.toString());
        JsonToken token = null;

        while((token = parser.nextToken()) != null) {
            if (token == JsonToken.FIELD_NAME) {
                System.out.println();
                System.out.print(parser.getText() + " -> ");
                token = parser.nextToken();
                if (token == JsonToken.VALUE_STRING) {
                    System.out.print(parser.getText());
                }
            }
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setUserID(String userID) {
        this.userID = userID;
    }

    public void setWorkID(String workID) {
        this.workID = workID;
    }

    public String getName() {
        return this.name;
    }

    public String getUserID() {
        return this.userID;
    }

    public String getWorkID() {
        return this.workID;
    }
}

