import kz.arta.synergy.api.rest.sample.asforms.*;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by root on 7/12/14.
 */
public class APIFormsServiceRunner {
    private static String login = "1";
    private static String password = "1";
    private static String address = "http://localhost:8080/Synergy";

    public static void runGetFormData() throws Exception {
        APIFormsServiceGetFormData service = new APIFormsServiceGetFormData(login, password, address);
        service.setDataUUID("b0fd5629-e161-45a5-955a-78856c3764dd");
        service.getFormData();
    }

    public static void runGetFormDataList() throws Exception {
        List<String> list = new ArrayList<String>();
        list.add("afe1f4d2-65b6-4367-a84d-fa232409a82b");
        list.add("5e8106e6-55a3-4c35-9c26-9e6a4d4f8db2");
        list.add("b0fd5629-e161-45a5-955a-78856c3764dd");
        APIFormsServiceGetFormDataList service = new APIFormsServiceGetFormDataList(login, password, address);
        service.setList(list);
        service.getFormData();
    }

    public static void runGetFormDefinition() throws Exception {
        APIFormsServiceGetFormDefinition service = new APIFormsServiceGetFormDefinition(login, password, address);
        service.setFormID("bc7d53e9-b070-4de6-98ca-50e76023673b");
        service.getFormDefinition();
    }

    public static void runSave() throws Exception {
        APIFormsServiceSave service = new APIFormsServiceSave(login, password, address);
        service.setFormUUID("296732ff-3877-4a34-9b9b-24e0b0c39be3");
        service.setUUID("1fa76be7-60ae-48b4-a919-77a6ea9b279f");
        service.setData("\"data\": [{\"id\":\"cmp-j69xbb\",\"type\":\"textbox\",\"value\":\"new text\"}]");
        service.save();
    }

    public static void runSearch() throws Exception {
        List<String> formUUID = new ArrayList<String>();
        List<String> search = new ArrayList<String>();
        List<String> field = new ArrayList<String>();
        List<String> type = new ArrayList<String>();
        String term;

        formUUID.add("3b224fe2-8dd0-48e9-9de6-dfacf5738144");
        search.add("Департамент2");
        field.add("department");
        type.add("exact");

        formUUID.add("3b224fe2-8dd0-48e9-9de6-dfacf5738144");
        search.add("Июнь");
        field.add("month");
        type.add("exact");

        term = "and";

        APIFormsServiceSearch service = new APIFormsServiceSearch(login, password, address);
        service.setFormUUIDList(formUUID);
        service.setFieldList(field);
        service.setSearchList(search);
        service.setTypeList(type);
        service.setTerm(term);

        service.search();
    }

    public static void main(String[] args) throws Exception {
        runGetFormData();
        runGetFormDataList();
        runGetFormDefinition();
        runSave();
        runSearch();
    }
}
