import kz.arta.synergy.api.rest.sample.storage.*;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by root on 7/13/15.
 */
public class StorageServiceRunner {

    private static String login = "1";
    private static String password = "1";
    private static String address = "http://localhost:8080/Synergy";

    public static void runStartUploadFile() throws Exception {
        StorageServiceStartUploadFile service = new StorageServiceStartUploadFile(login, password, address);
        service.startUploadFile();
    }

    public static void runListFiles() throws Exception {
        StorageServiceListFiles service = new StorageServiceListFiles(login, password, address);
        service.setParentID("ea00edc9-b9ea-4251-8d88-4b1d7d78863c");
        service.listFiles();
    }

    public static void runSearch() throws Exception {
        List<Integer> list = new ArrayList<Integer>();
        list.add(new Integer(1));
        StorageServiceSearch service = new StorageServiceSearch(login, password, address);
        service.setContains("New");
        service.setNotContains("asd");
        service.setCategoryID(list);
        service.setIncludeExpired(true);
        service.search();
    }

    public static void runCreateAttachment() throws Exception {
        StorageServiceCreateAttachment service = new StorageServiceCreateAttachment(login, password, address);
        service.setDocID("c60e25de-bb09-4628-826e-9a57fb809f25");
        service.setFileName("doc");
        service.setFilePath("/home/acer/Documents/logsTest.txt");
        service.setPath("ase:attachmentContainer");
        service.createAttachment();
    }

    public static void runUploadPart() throws Exception {
        StorageServiceUploadPart service = new StorageServiceUploadPart(address, login, password);
        service.setFile("/opt/synergy/jboss/standalone/tmp/Synergy/upload.tmp/c6f7f0d0-1b5e-4f43-b664-d432c918d964");
        service.uploadPart();
    }
    public static void main(String[] args) throws Exception {
        //runStartUploadFile();
        //-runListFiles();
        //runSearch();
        //runCreateAttachment();
        //runUploadPart();
    }
}