package nce.integration.synergy.RestCont;

import lombok.RequiredArgsConstructor;
import nce.integration.synergy.exception.ApiRequestException;
import nce.integration.synergy.service.NceIntegrationService;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.*;

import java.io.IOException;
import java.net.URISyntaxException;
import java.text.ParseException;

@RestController
@CrossOrigin(origins = "*", allowedHeaders = "*")
@RequestMapping({"/nce/api"})
@RequiredArgsConstructor
public class NceIntegrationRest {
    private final NceIntegrationService nceIntegration;

    @GetMapping({"/token"})
    @ResponseStatus(HttpStatus.OK)
    public Boolean getToken() throws IOException, URISyntaxException, ParseException {
        try {
            nceIntegration.getCovidData();
            return true;
        } catch (Exception e) {
            throw new ApiRequestException(e.getMessage());
        }
    }

}
