package nce.integration.synergy.repo;

import feign.Headers;
import feign.Response;
import nce.integration.synergy.Const;
import nce.integration.synergy.entity.AuthData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.net.URI;

@FeignClient(value = "report", url = Const.NCE_HOST)
public interface FeignClientRepo {

    @GetMapping("")
    Response getDictionaryData(@RequestHeader("Authorization") String Token, URI baseUrl);

    @PostMapping("")
    ResponseEntity<Void> postRequest(@RequestHeader("Authorization") String Token, URI baseUrl);

    @GetMapping("")
    ResponseEntity<Void> getAuth(@RequestHeader("Authorization") String Token, URI baseUrl);

    @RequestMapping(method = RequestMethod.POST, path = "/api/v1/authenticate", consumes = MediaType.APPLICATION_JSON_VALUE, produces = MediaType.APPLICATION_JSON_VALUE)
    @Headers("Content-Type: application/json")
    Response getNceToken(@RequestBody AuthData body);

    @RequestMapping(method = RequestMethod.POST, path = "/api/v1/monitoring/covid/all", consumes = MediaType.APPLICATION_JSON_VALUE, produces = MediaType.APPLICATION_JSON_VALUE)
    @Headers("Content-Type: application/json")
    Response getCovidData(@RequestHeader("Authorization") String bearerToken);
}

