package nce.integration.synergy.entity;

import lombok.Data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@Data
public class DictionaryData {

    private String id;
    private String code;
    private String name;
    private HashMap<String, PCRData> items;

    @Data
    public class PCRData {
        private CmpData bin;
        private CmpData name;
        private CmpData id;
    }

    @Data
    public class CmpData {
        private String id;
        private String value;
    }

    public List<String> getALLBin() {
        List<String> binList = new ArrayList<>();

        for (String key : items.keySet())
            binList.add(items.get(key).getBin().getValue());

        return binList;
    }

    public List<String> getALLBinName() {
        List<String> binList = new ArrayList<>();

        for (String key : items.keySet())
            binList.add(items.get(key).getName().getValue());

        return binList;
    }
}
