package nce.integration.synergy.repo;

import feign.Headers;
import feign.Response;
import nce.integration.synergy.Const;
import nce.integration.synergy.entity.MergeDataFormat;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@FeignClient(value = "synergy", url = Const.SYNERGY_HOST)
public interface SynergyClientRepo {

    @RequestMapping(method = RequestMethod.POST, path = "/rest/api/asforms/data/merge", consumes = MediaType.APPLICATION_JSON_VALUE, produces = MediaType.APPLICATION_JSON_VALUE)
    @Headers("Content-Type: application/json")
    Response mergeCovidData(@RequestHeader("Authorization") String bearerToken, @RequestBody MergeDataFormat body);
}
