package kz.arta.synergy.api.rest.sample.asforms;

import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.xml.bind.DatatypeConverter;

/**
 *
 * класс демонстрации работы метода save класса APIFormsService
 *
 * Created by root on 7/12/14.
 */
public class APIFormsServiceSave {

    /**
     * Переменная логина пользователя вызывающего метод.
     */
    private String login;
    /**
     * Переменная пароля пользователя вызывающего метод.
     */
    private String password;
    private String encoded;
    /**
     * Переменная URL Arta Synergy.
     */
    private String address;
    // UUID формы (параметр запроса)
    private String formUUID;
    // UUID данных по форме (параметр запроса)
    private String uuid;
    //идентификатор папки в хранилище, в которой должен быть создан файл по форме (имеет смысл только если uuid равен null)
    private String parentID;
    // json с данными по форме (параметр формы)
    private String data;

    /**
     * Сохранение данных по форме
     * @param login - Login
     * @param password - Password
     * @param address - Address
     * @param formUUID - Target form UUID
     * @param uuid - Target form data UUID
     * @param data - Form data
     */
    public APIFormsServiceSave(String login, String password, String address, String formUUID, String uuid, String data) {
        this.login = login;
        this.password = password;
        this.address = address;
        this.formUUID = formUUID;
        this.uuid = uuid;
        this.data = data;
        this.encoded = DatatypeConverter.printBase64Binary((login + ":" + password).getBytes());
    }

    public void save() throws Exception {
        URL url = new URL(address + "/rest/api/asforms/data/save");
        HttpURLConnection connection = (HttpURLConnection) url.openConnection();
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Accept", "application/json; charset=utf-8");
        connection.setRequestProperty("Authorization", "Basic " + encoded);
        connection.setRequestProperty("Connection", "Keep-Alive");
        connection.setUseCaches(true);
        connection.setDoInput(true);
        connection.setDoOutput(true);

        DataOutputStream request = new DataOutputStream(connection.getOutputStream());
        request.writeBytes("formUUID=" + formUUID);
        request.writeBytes("&");
        if (uuid != null) {
            request.writeBytes("uuid=" + uuid);
        } else {
            request.writeBytes("parentID=" + parentID);
        }
        request.writeBytes("&");
        request.writeBytes("data=" + data);
        request.flush();
        request.close();

        InputStream is = connection.getInputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        StringBuilder response = new StringBuilder();
        String line;

        while ((line = br.readLine()) != null) {
            response.append(line);
        }

        br.close();
        is.close();

        JsonFactory factory = new JsonFactory();
        JsonParser parser = factory.createJsonParser(response.toString());
        JsonToken token = null;

        while ((token = parser.nextToken()) != null) {
            if (token == JsonToken.FIELD_NAME) {
                System.out.println();
                System.out.print(parser.getText() + " -> ");
                token = parser.nextToken();
                if (token == JsonToken.VALUE_STRING) {
                    System.out.print(parser.getText());
                }
            }
        }
    }

    public void setFormUUID(String formUUID) {
        this.formUUID = formUUID;
    }

    public void setUUID(String uuid) {
        this.uuid = uuid;
    }

    public void setParentID(String parentID) {
        this.parentID = parentID;
    }

    public void setData(String data) {
        this.data = data;
    }

    public String getFormUUID() {
        return this.formUUID;
    }

    public String getUUID() {
        return this.uuid;
    }

    public String getData() {
        return this.data;
    }

    public String getParentID() {
        return this.parentID;
    }
}
