package kz.arta.synergy.astdev.custom_bp;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import org.codehaus.jackson.JsonNode;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.MessageDriven;
import javax.naming.NameNotFoundException;
import javax.naming.directory.AttributeModificationException;
import javax.xml.bind.DatatypeConverter;
import kz.arta.synergy.api.rest.sample.asforms.APIFormsServiceSave;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.codehaus.jackson.type.TypeReference;

/**
 *
 * @author drpsy
 */
@MessageDriven(name = "CustomBP", activationConfig = {
    @ActivationConfigProperty(propertyName = "destinationType", propertyValue = "javax.jms.Queue"),
        @ActivationConfigProperty(propertyName = "destination", propertyValue = "java:jboss/queues/Integration/CustomBP"),
        @ActivationConfigProperty(propertyName = "reconnectAttempts", propertyValue = "32"),
        @ActivationConfigProperty(propertyName = "reconnectInterval", propertyValue = "4000"),
        @ActivationConfigProperty(propertyName = "acknowledgeMode", propertyValue = "Auto-acknowledge")})

public class Main implements MessageListener {

    private static final Logger LOGGER = LoggerFactory.getLogger(Main.class);
    private static final ObjectMapper OBJECTMAPPER = new ObjectMapper();

    private static enum fieldType {
        DATE, TEXTBOX, USER
    }
    private static enum fields {
        ID, TYPE, LABEL, KEY, VALUE
    }

    private String executionID = null;  // идентификатор блокирующего процесса
    private String documentID = null;   // идентификатор документа реестра
    
    private static final String LOGIN = "111111";
    private static final String PASSWORD = "1";
    private final String TARGETFORMUUID = "fb44d99d-1579-4ac3-884a-01a6d4f71f9c";
    private final String SYNERGYADDRESS = "http://127.0.0.1:8080/Synergy";
    private String SOURCEFORMDATAUUID = null; // идентификатор данных по форме записи реестра
    private String TARGETFORMDATAUUID = null;

    @JsonSerialize(using = AsNodeSerializer.class)
    private List<AsNode> sourceFormData = null;
    @JsonSerialize(using = AsNodeSerializer.class)
    private List<AsNode> targetFormData = null;

    /**
     *
     * @param message
     */
    @Override
    public void onMessage(Message message) {
        if (!(message instanceof TextMessage)) {
            return;
        }

        try {
            JsonFactory factory = new JsonFactory();
            JsonParser parser = factory.createParser(((TextMessage) message).getText());
            JsonToken token = null;

            while ((token = parser.nextToken()) != null) {
                if (token == JsonToken.FIELD_NAME) {
                    String fieldName = parser.getText();
                    parser.nextToken();
                    String value = parser.getText();
                    switch (fieldName) {
                        case "dataUUID":
                            SOURCEFORMDATAUUID = value;
                            break;
                        case "executionID":
                            executionID = value;
                            break;
                        case "documentID":
                            documentID = value;
                            break;
                        default:
                            break;
                    }
                }
            }

            // Получение данных исходной формы (той, по которой запущен маршрут)
            URL sourceFormURL = new URL(SYNERGYADDRESS + "/rest/api/asforms/data/" + SOURCEFORMDATAUUID);
            String sourceFormDataAsString = synergyApiGetString(sourceFormURL);
            
            JsonNode SourceRootNode = OBJECTMAPPER.readTree(sourceFormDataAsString);  // read the whole tree
            if (SourceRootNode.isNull()) {
                throw new AttributeModificationException("GMP: Passed data has no JSON content");
            }
            JsonNode SourceRootDataNode = SourceRootNode.get("data"); // read single root 'data' node
            if (SourceRootDataNode == null) {
                throw new AttributeModificationException("GMP: Invalid form data, root \"data\" node does not exists");
            }
            sourceFormData = OBJECTMAPPER.readValue(SourceRootDataNode, new TypeReference<List<AsNode>>() {}); // map content of single root 'data' node
            
            // Получение ID пользователя указанного в форме
            String userID = getComponentValueByID(this.sourceFormData, "user1", fields.KEY); // TODO: Pass JsonNode, not String
            // По ID пользователя указанного в карточке и ID формы получаем DataUUID целевой карточки (ID for work: "04f7809d-f44c-4a2d-950d-6aa8e6c3fea1")
            String userCardDataUUID = getCardDataUUID(userID, TARGETFORMUUID);
            // Получение данных целевой карточки по dataUUID
            URL targetFormURL = new URL(SYNERGYADDRESS + "/rest/api/asforms/data/" + userCardDataUUID);
            TARGETFORMDATAUUID = synergyApiGetString(targetFormURL);
            JsonNode TargetRootNode = OBJECTMAPPER.readTree(TARGETFORMDATAUUID);
            if (TargetRootNode.isNull()) {
                throw new AttributeModificationException("GMP: Passed data has no JSON content");
            }
            JsonNode TargetRootDataNode = TargetRootNode.get("data");
            if (TargetRootDataNode == null) {
                throw new AttributeModificationException("GMP: Invalid form data, root \"data\" node does not exists");
            }
            targetFormData = OBJECTMAPPER.readValue(TargetRootDataNode, new TypeReference<List<AsNode>>() {});
            
            // Получение значений текущих дат исходной формы
            String b5b1;
            
            String t2b1;
            String t8b1;
            
//            String t18b1, t20b1, t16b1;
//            String t26b1, t24b1, t22b1;
//            String t32b1, t30b1, t28b1;
            
            // first table
            String b2b1 = getComponentValueByID(this.sourceFormData, "b2-b1-b1", fields.KEY);
            String b4b1 = getComponentValueByID(this.sourceFormData, "b4-b1-b1", fields.KEY);

            if (!b2b1.isEmpty() && !b4b1.isEmpty()) {
                updateFieldValue(this.targetFormData, "start-b1", fields.KEY, b2b1);
                updateFieldValue(this.targetFormData, "finish-b1", fields.KEY, b4b1);
                
                updateUserCard();
                
                unlockRoute();
                return;
            }
            
            // Second table
//            String t4b1 = getComponentValueByID(sourceFormData, "t2-b1", fieldType.DATE);
//            String t6b1 = getComponentValueByID(sourceFormData, "b6-b1", fieldType.DATE);
//            String t10b1 = getComponentValueByID(sourceFormData, "t10-b1", fieldType.DATE);
//            String t12b1 = getComponentValueByID(sourceFormData, "t12-b1", fieldType.DATE);
//            
//            if (!t4b1.isEmpty() && !t6b1.isEmpty() && !t10b1.isEmpty() && !t12b1.isEmpty()) {
//                setComponentValueByID(targetFormData, "start-b1", "key", b2b1);
//                setComponentValueByID(targetFormData, "start-b1", "key", b2b1);
//                setComponentValueByID(targetFormData, "start-b1", "key", b2b1);
//                setComponentValueByID(targetFormData, "start-b1", "key", b2b1);
//                
//                unlockRoute();
//                return;
//            }

            // Разблокировка маршрута
            unlockRoute();

        } catch (Exception exc) {
            LOGGER.error(exc.getMessage(), exc);
        }
    }
    
      
    private void updateUserCard() throws IOException {
        // SERIALIZATION
        OBJECTMAPPER.setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
        String serialData = OBJECTMAPPER.writeValueAsString(targetFormData);
        
        APIFormsServiceSave saver = new APIFormsServiceSave(LOGIN, PASSWORD, SYNERGYADDRESS, TARGETFORMUUID, TARGETFORMDATAUUID, serialData);
    }
    
    /**
     * Returns node which has specifies ID
     * @param nodesList - List of nodes
     * @param componentID - Component ID
     * @return AsNode if such exists, null otherwise
     */
    private static AsNode findNode(List<AsNode> nodesList, String componentID) {
        AsNode result = null;
        
        for (AsNode n : nodesList) {
            if (result != null) break;  // prevent relooping if result has already been found
            
            if (componentID.equals(n.getId())) {
                result = n;
            } else if (n.getData() != null) {
                result = findNode(n.getData(), componentID);
            }
        }
        
        return result;
    }
    
    /**
     * Setting new value of requested field of requested component with specified ID
     * @param targetJsonAsString
     * @param componentID
     * @param fieldName
     * @param newFieldValue
     * @throws AttributeModificationException
     * @throws IOException 
     */
    private void updateFieldValue (List<AsNode> dataNodesList, String componentID, fields fieldName, String newFieldValue) throws AttributeModificationException, IOException {

        try {
            
            AsNode targetNode = findNode(dataNodesList, componentID);
            if (targetNode == null) {
                throw new AttributeModificationException("GMP: Node with specified ID is not found in passed JSON");
            } else {
                switch (fieldName) {
                    case ID:
                        targetNode.setId(newFieldValue);
                        break;
                    case TYPE:
                        targetNode.setType(newFieldValue);
                        break;
                    case LABEL:
                        targetNode.setLabel(newFieldValue);
                        break;
                    case KEY:
                        targetNode.setKey(newFieldValue);
                        break;
                    case VALUE:
                        targetNode.setValue(newFieldValue);
                        break;
                }
            }
        } catch (AttributeModificationException e) {
            throw e;
        }
    }
   
    /**
     * Returns user's card data UUID by form's UUID
     * @param userID - User identifier
     * @param formUUID - Form's data UUID
     * @return Specified user's card data UUID
     */
    private static String getCardDataUUID (String userID, String formUUID) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            URL url = new URL("http://127.0.0.1:8080/Synergy/rest/api/personalrecord/forms/" + userID);
            String res = synergyApiGetString(url);
            
            List<Card> cardsList = mapper.readValue(res, new TypeReference<List<Card>>(){});
            
            for (Card c : cardsList) {
                if (formUUID.equals(c.getFormUUID())) {
                    return c.getDataUUID();
                }
            }
        } catch (Exception exc) {
            LOGGER.error(exc.getMessage(), exc);
        }
        return new String();
    }
    
    /**
     * Returns value of of specified field of component with specified ID
     * @param targetJsonAsString
     * @param componentID
     * @param fieldName
     * @return
     * @throws NameNotFoundException
     * @throws IOException 
     */
    private static String getComponentValueByID(List<AsNode> dataNodesList, String componentID, fields fieldName) throws Exception {
        String result = null;
        try {

            AsNode targetNode = findNode(dataNodesList, componentID);
            if (targetNode == null) {
                throw new Exception("GMP: Node with specified ID is not found in passed JSON");
            } else {
                switch (fieldName) {
                    case ID:
                        result = targetNode.getId();    // may be for cheking if component with such ID exists at all
                        break;
                    case TYPE:
                        result = targetNode.getType();
                        break;
                    case LABEL:
                        result = targetNode.getLabel();
                        break;
                    case KEY:
                        result = targetNode.getKey();
                        break;
                    case VALUE:
                        result = targetNode.getValue();
                        break;
                }
            } 
            return result;
        } catch (Exception e) {
            throw e;
        }

    }
    
    /**
     * Route unlocking
     */
    private void unlockRoute() {
        try {
            String address = "http://127.0.0.1:8080/Synergy";
            String signal = "got_agree";
            URL url = new URL(address + "/rest/api/processes/signal?signal=" + signal + "&executionID=" + this.executionID + "&param1=resolution&value1=signal_is_" + signal);
            synergyApiGetString(url);
        } catch (Exception exc) {
            LOGGER.error(exc.getMessage(), exc);
        }
    }
    
    private static String synergyApiGetString(final URL requestURL) {
        try {
            String output;

            HttpURLConnection conn = (HttpURLConnection) requestURL.openConnection();
            conn.setRequestMethod("GET");
            conn.setRequestProperty("Accept", "application/json; charset=utf-8");

            String encoded = DatatypeConverter.printBase64Binary((LOGIN + ":" + PASSWORD).getBytes());    // String encoded = Base64.encode((this.LOGIN + ":" + this.PASSWORD).getBytes());
            conn.setRequestProperty("Authorization", "Basic " + encoded);

            BufferedReader br = new BufferedReader(new InputStreamReader((conn.getInputStream())));
            StringBuilder result = new StringBuilder();
            while ((output = br.readLine()) != null) {
                result.append(output);
            }

            conn.disconnect();

            JsonFactory factory = new JsonFactory();
            return result.toString();
        } catch (Exception exc) {
            LOGGER.error(exc.getMessage(), exc);
        }

        return null;
    }
}
