package kz.arta.synergy.astdev.custom_bp;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import org.codehaus.jackson.JsonNode;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.MessageDriven;
import javax.naming.NameNotFoundException;
import javax.naming.directory.AttributeModificationException;
import javax.servlet.ServletContext;
import javax.xml.bind.DatatypeConverter;
import kz.arta.synergy.api.rest.sample.asforms.APIFormsServiceSave;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.codehaus.jackson.type.TypeReference;

/**
 *
 * @author drpsy
 */
@MessageDriven(name = "CustomBP", activationConfig = {
    @ActivationConfigProperty(propertyName = "destinationType", propertyValue = "javax.jms.Queue"),
        @ActivationConfigProperty(propertyName = "destination", propertyValue = "java:jboss/queues/Integration/CustomBP"),
        @ActivationConfigProperty(propertyName = "reconnectAttempts", propertyValue = "32"),
        @ActivationConfigProperty(propertyName = "reconnectInterval", propertyValue = "4000"),
        @ActivationConfigProperty(propertyName = "acknowledgeMode", propertyValue = "Auto-acknowledge")})

public class Main implements MessageListener {

    private static final Logger LOGGER = LoggerFactory.getLogger(Main.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    private static enum ObjectType {
        DATE, TEXTBOX, USER
    }
    private static enum FieldType {
        ID, TYPE, LABEL, KEY, VALUE
    }

    private String executionID = null;  // идентификатор блокирующего процесса
    private String documentID = null;   // идентификатор документа реестра
    
    private static final String LOGIN = "Ипатьев";
    private static final String PASSWORD = "1";
//    private final String TARGET_FORM_UUID = "fb44d99d-1579-4ac3-884a-01a6d4f71f9c"; // home
    private final String TARGET_FORM_UUID = "04f7809d-f44c-4a2d-950d-6aa8e6c3fea1"; // work
    private final String SYNERGY_ADDRESS = "http://127.0.0.1:8080/Synergy";
    private String SOURCE_FORM_DATA_UUID = null; // идентификатор данных по форме записи реестра
    private String TARGET_FORM_DATA_UUID = null;

    @JsonSerialize(using = AsNodeSerializer.class)
    private List<AsNode> sourceFormData = null;
    @JsonSerialize(using = AsNodeSerializer.class)
    private List<AsNode> targetFormData = null;

    /**
     *
     * @param message
     */
    @Override
    public void onMessage(Message message) {
// <editor-fold defaultstate="collapsed" desc=" DESCRIPTION ">
        if (!(message instanceof TextMessage)) {
            return;
        }
        
        try {
            JsonFactory factory = new JsonFactory();
            JsonParser parser = factory.createParser(((TextMessage) message).getText());
            JsonToken token = null;
            
            while ((token = parser.nextToken()) != null) {
                if (token == JsonToken.FIELD_NAME) {
                    String fieldName = parser.getText();
                    parser.nextToken();
                    String value = parser.getText();
                    switch (fieldName) {
                        case "dataUUID":
                            SOURCE_FORM_DATA_UUID = value;
                            break;
                        case "executionID":
                            executionID = value;
                            break;
                        case "documentID":
                            documentID = value;
                            break;
                        default:
                            break;
                    }
                }
            }

// </editor-fold>
            // Configure ObjectMapper
            OBJECT_MAPPER.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            
            constructTableHeader();
            
            // SOURCE FORM: Получение данных исходной формы (той, по которой запущен маршрут)
            URL sourceFormURL = new URL(SYNERGY_ADDRESS + "/rest/api/asforms/data/" + SOURCE_FORM_DATA_UUID);
            String sourceFormDataAsString = synergyApiGetString(sourceFormURL);
            JsonNode SourceRootNode = OBJECT_MAPPER.readTree(sourceFormDataAsString);  // read the whole tree
            if (SourceRootNode.isNull()) {
                throw new AttributeModificationException("GMP: Passed data has no JSON content");
            }
            JsonNode SourceRootDataNode = SourceRootNode.get("data"); // read single root 'data' node
            if (SourceRootDataNode == null) {
                throw new AttributeModificationException("GMP: Invalid form data, root \"data\" node does not exists");
            }
            sourceFormData = OBJECT_MAPPER.readValue(SourceRootDataNode, new TypeReference<List<AsNode>>() {}); // map content of single root 'data' node
            
            // TARGET FORM: Получение ID пользователя указанного в форме
            String userID = getComponentValueByID(this.sourceFormData, "user1", FieldType.KEY);
            if (userID == null) {
                throw new Exception("User in not specified in the order (value of \"user1\" field is not found)");
            }
            // По ID пользователя указанного в карточке и ID формы получаем DataUUID целевой карточки (ID for work: "04f7809d-f44c-4a2d-950d-6aa8e6c3fea1")
            TARGET_FORM_DATA_UUID = getCardDataUUID(userID, TARGET_FORM_UUID);
            // Получение данных целевой карточки по dataUUID
            
            URL targetFormURL = new URL(SYNERGY_ADDRESS + "/rest/api/asforms/data/" + TARGET_FORM_DATA_UUID);
            String targetFormDataAsString = synergyApiGetString(targetFormURL);
            JsonNode TargetRootNode = OBJECT_MAPPER.readTree(targetFormDataAsString);
            if (TargetRootNode.isNull()) {
                throw new AttributeModificationException("GMP: Passed data has no JSON content");
            }
            JsonNode TargetRootDataNode = TargetRootNode.get("data");
            if (TargetRootDataNode == null) {
                throw new AttributeModificationException("GMP: Invalid form data, root \"data\" node does not exists");
            }
            targetFormData = OBJECT_MAPPER.readValue(TargetRootDataNode, new TypeReference<List<AsNode>>() {});
            
            // common vacation period
            String vacStart = getComponentValueByID(this.sourceFormData, "date_start", FieldType.KEY);
            String vacEnd = getComponentValueByID(this.sourceFormData, "date_finish", FieldType.KEY);
            String days = getComponentValueByID(this.sourceFormData, "days", FieldType.VALUE);
            
            if (vacStart == null || vacEnd == null) {
                throw new Exception("Vacation period is not specified");
            }
            
            // first table - periods
            String b2b1 = getComponentValueByID(this.sourceFormData, "b2-b1", FieldType.KEY);
            String b4b1 = getComponentValueByID(this.sourceFormData, "b4-b1", FieldType.KEY);
            // first table - num of days
            String b5b1 = getComponentValueByID(this.sourceFormData, "b5-b1", FieldType.VALUE);

            if (notNull(b2b1, b4b1)) {    // отображается key
                constructNewTableRow(vacStart, vacEnd, b2b1, b4b1, b5b1);
                updateTargetForm();
                return;
            }
            
            // second table - periods
            String t4b1 = getComponentValueByID(this.sourceFormData, "t4-b1", FieldType.KEY);
            String t6b1 = getComponentValueByID(this.sourceFormData, "t6-b1", FieldType.KEY);
            String t10b1 = getComponentValueByID(this.sourceFormData, "t10-b1", FieldType.KEY);
            String t12b1 = getComponentValueByID(this.sourceFormData, "t12-b1", FieldType.KEY);
            // second table - num of days
            String t2b1 = getComponentValueByID(this.sourceFormData, "t2-b1", FieldType.VALUE);
            String t8b1 = getComponentValueByID(this.sourceFormData, "t8-b1", FieldType.VALUE);
            
            if (notNull(t4b1, t6b1, t10b1, t12b1)) {
                constructNewTableRow(vacStart, vacEnd, t4b1, t6b1, t2b1);
                constructNewTableRow(vacStart, vacEnd, t10b1, t12b1, t8b1);
                updateTargetForm();
                return;
            }
            
            // third table - periods
            String t18b1 = getComponentValueByID(this.sourceFormData, "t18-b1", FieldType.KEY);
            String t20b1 = getComponentValueByID(this.sourceFormData, "t20-b1", FieldType.KEY);
            String t24b1 = getComponentValueByID(this.sourceFormData, "t24-b1", FieldType.KEY);
            String t26b1 = getComponentValueByID(this.sourceFormData, "t26-b1", FieldType.KEY);
            String t30b1 = getComponentValueByID(this.sourceFormData, "t30-b1", FieldType.KEY);
            String t32b1 = getComponentValueByID(this.sourceFormData, "t32-b1", FieldType.KEY);
            // third table - num of days
            String t16b1 = getComponentValueByID(this.sourceFormData, "t16-b1", FieldType.VALUE);
            String t22b1 = getComponentValueByID(this.sourceFormData, "t22-b1", FieldType.VALUE);
            String t28b1 = getComponentValueByID(this.sourceFormData, "t28-b1", FieldType.VALUE);
            
            if (notNull(t18b1, t20b1, t24b1, t26b1, t30b1, t32b1)) {
                constructNewTableRow(vacStart, vacEnd, t18b1, t20b1, t16b1);
                constructNewTableRow(vacStart, vacEnd, t24b1, t26b1, t22b1);
                constructNewTableRow(vacStart, vacEnd, t30b1, t32b1, t28b1);
                updateTargetForm();
                return;
            }
            
        } catch (Exception exc) {
            LOGGER.error(exc.getMessage(), exc);
        } finally {
            unlockRoute(); // Разблокировка маршрута
        }
    }
    
    private List<AsNode> constructTableHeader() throws IOException {
        InputStream inputStream = getClass().getClassLoader().getResourceAsStream("table_header.json");
        List<AsNode> l = OBJECT_MAPPER.readValue(inputStream, new TypeReference<List<AsNode>>() {});
        return l;
    }
    
    private static boolean notNull(Object... args) {
        for (Object arg : args) {
            if (arg == null) {
                return false;
            }
        }
        return true;
    }
    
    private void constructNewTableRow(String vacStart, String vacEnd, String perStart, String perEnd, String numDays) throws Exception {
        AsNode tableNode = findNode(targetFormData, "table");
        if (tableNode != null) {
            List<AsNode> tableDataNodesList = tableNode.getData();
            String tablesCounter = Integer.toString(appendabeTableRowsCount(tableDataNodesList, "start", "b") + 1);

            AsNode n1 = new AsNode();
            AsNode n2 = new AsNode();
            AsNode n3 = new AsNode();
            AsNode n4 = new AsNode();
            AsNode n5 = new AsNode();
            AsNode n6 = new AsNode();
            AsNode n7 = new AsNode();

            n1.setId("start-b" + tablesCounter);
            n1.setType("date");
            n1.setLabel(" ");
            n1.setValue(dateValueFromKey(vacStart));
            n1.setKey(vacStart);

            n2.setId("finish-b" + tablesCounter);
            n2.setType("date");
            n2.setLabel(" ");
            n2.setValue(dateValueFromKey(vacEnd));
            n2.setKey(vacEnd);

            n3.setId("days-b" + tablesCounter);
            n3.setType("textbox");
            n3.setLabel(" ");
            n3.setValue(numDays);

            n4.setId("matpom-b" + tablesCounter);
            n4.setType("listbox");
            n4.setValue("");
            n4.setKey(""); // TODO: Update or not update?

            n5.setId("period_start-b" + tablesCounter);
            n5.setType("date");
            n5.setValue(dateValueFromKey(perStart));
            n5.setKey(perStart);

            n6.setId("period_finish-b" + tablesCounter);
            n6.setType("date");
            n6.setValue(dateValueFromKey(perEnd));
            n6.setKey(perEnd);

            n7.setId("otozvano-b" + tablesCounter);
            n7.setType("texbox");
            n7.setLabel(" ");

            tableDataNodesList.add(n1);
            tableDataNodesList.add(n2);
            tableDataNodesList.add(n3);
            tableDataNodesList.add(n4);
            tableDataNodesList.add(n5);
            tableDataNodesList.add(n6);
            tableDataNodesList.add(n7);
        }
    }
    
    private int dateDiffToDays(String dateLess, String dateMore) throws ParseException {
        Date dateMore_ = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(dateMore);
        Date dateLess_ = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(dateLess);

        long diff = dateMore_.getTime() - dateLess_.getTime();
        TimeUnit.DAYS.convert(diff, TimeUnit.MILLISECONDS);

        return (int) TimeUnit.DAYS.convert(diff, TimeUnit.MILLISECONDS);
    }

    private int appendabeTableRowsCount(List<AsNode> lan, String tableID, String tableElementID) {
        int counter = 0;
        for (;;) {
            String searchString = tableID + "-" + tableElementID + Integer.toString(counter + 1);
            AsNode n = findNode(lan, searchString);
            if (n == null) {
                break;
            } else {
                counter++;
            }
        }
        return counter;
    }
    
    private void updateTargetForm() throws IOException, Exception {
        // SERIALIZATION
        OBJECT_MAPPER.setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
        String serialData = OBJECT_MAPPER.writeValueAsString(targetFormData);
        
        // String login, String password, String address, String formUUID, String uuid, String data
        APIFormsServiceSave saver = new APIFormsServiceSave(LOGIN, PASSWORD, SYNERGY_ADDRESS, TARGET_FORM_UUID, TARGET_FORM_DATA_UUID, "\"data\": " +  serialData);
        saver.save();
    }
    
    /**
     * Returns node which has specifies ID
     * @param nodesList - List of nodes
     * @param objectID - Component ID
     * @return AsNode if such exists, null otherwise
     */
    private static AsNode findNode(List<AsNode> nodesList, String objectID) {
        AsNode result = null;
        
        for (AsNode n : nodesList) {
            if (result != null) break;  // prevent relooping if result has already been found
            
            if (objectID.equals(n.getId())) {
                result = n;
            } else if (n.getData() != null) {
                result = findNode(n.getData(), objectID);
            }
        }
        
        return result;
    }
    
    private static String dateValueFromKey (String keyValue) throws ParseException {     
        Date date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(keyValue);
        return new SimpleDateFormat("dd.MM.yyy").format(date);
    }
    
    /**
     * Setting new value of requested field of requested component with specified ID
     * @param targetJsonAsString
     * @param objectID
     * @param fieldType
     * @param newFieldValue
     * @throws AttributeModificationException
     * @throws IOException 
     */
    private boolean updateFieldValue (List<AsNode> dataNodesList, String objectID, FieldType fieldType, String newFieldValue) {
        try {
            AsNode targetNode = findNode(dataNodesList, objectID);
            if (targetNode == null) {
                return false;
            } else {
                switch (fieldType) {
                    case ID:
                        targetNode.setId(newFieldValue);
                        break;
                    case TYPE:
                        targetNode.setType(newFieldValue);
                        break;
                    case LABEL:
                        targetNode.setLabel(newFieldValue);
                        break;
                    case KEY:
                        targetNode.setKey(newFieldValue);
                        break;
                    case VALUE:
                        targetNode.setValue(newFieldValue);
                        break;
                }
            }
            return true;
        } catch (Exception e) {
            throw e;
        }
    }
    
    /**
     * Returns user's card data UUID by form's UUID
     * @param userID - User identifier
     * @param formUUID - Form's data UUID
     * @return Specified user's card data UUID
     */
    private static String getCardDataUUID (String userID, String formUUID) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            URL url = new URL("http://127.0.0.1:8080/Synergy/rest/api/personalrecord/forms/" + userID);
            String res = synergyApiGetString(url);
            
            List<Card> cardsList = mapper.readValue(res, new TypeReference<List<Card>>(){});
            
            for (Card c : cardsList) {
                if (formUUID.equals(c.getFormUUID())) {
                    return c.getDataUUID();
                }
            }
        } catch (Exception exc) {
            LOGGER.error(exc.getMessage(), exc);
        }
        return new String();
    }
    
    /**
     * Returns value of of specified field of component with specified ID
     * @param targetJsonAsString
     * @param objectID
     * @param fieldType
     * @return
     * @throws NameNotFoundException
     * @throws IOException 
     */
    private static String getComponentValueByID(List<AsNode> dataNodesList, String objectID, FieldType fieldType) throws Exception {
        String result = null;
        try {

            AsNode targetNode = findNode(dataNodesList, objectID);
            if (targetNode == null) {
                return null;
            } else {
                switch (fieldType) {
                    case ID:
                        result = targetNode.getId();    // may be for cheking if component with such ID exists at all
                        break;
                    case TYPE:
                        result = targetNode.getType();
                        break;
                    case LABEL:
                        result = targetNode.getLabel();
                        break;
                    case KEY:
                        result = targetNode.getKey();
                        break;
                    case VALUE:
                        result = targetNode.getValue();
                        break;
                }
            } 
            return result;
        } catch (Exception e) {
            throw e;
        }

    }
    
    /**
     * Route unlocking
     */
    private void unlockRoute() {
        try {
            String address = "http://127.0.0.1:8080/Synergy";
            String signal = "got_agree";
            URL url = new URL(address + "/rest/api/processes/signal?signal=" + signal + "&executionID=" + this.executionID + "&param1=resolution&value1=signal_is_" + signal);
            synergyApiGetString(url);
        } catch (Exception exc) {
            LOGGER.error(exc.getMessage(), exc);
        }
    }
    
    private static String synergyApiGetString(final URL requestURL) {
        try {
            String output;

            HttpURLConnection conn = (HttpURLConnection) requestURL.openConnection();
            conn.setRequestMethod("GET");
            conn.setRequestProperty("Accept", "application/json; charset=utf-8");

            String encoded = DatatypeConverter.printBase64Binary((LOGIN + ":" + PASSWORD).getBytes());    // String encoded = Base64.encode((this.LOGIN + ":" + this.PASSWORD).getBytes());
            conn.setRequestProperty("Authorization", "Basic " + encoded);

            BufferedReader br = new BufferedReader(new InputStreamReader((conn.getInputStream())));
            StringBuilder result = new StringBuilder();
            while ((output = br.readLine()) != null) {
                result.append(output);
            }

            conn.disconnect();

            JsonFactory factory = new JsonFactory();
            return result.toString();
        } catch (Exception exc) {
            LOGGER.error(exc.getMessage(), exc);
        }

        return null;
    }
}
