/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package kz.arta.synergy.astdev.custom_bp;

import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.MessageDriven;

@MessageDriven(name = "CustomBP", activationConfig = {
        @ActivationConfigProperty(propertyName = "destinationType", propertyValue = "javax.jms.Queue"),
        @ActivationConfigProperty(propertyName = "destination", propertyValue = "java:jboss/queues/Integration/CustomBP"),
        @ActivationConfigProperty(propertyName = "reconnectAttempts", propertyValue = "32"),
        @ActivationConfigProperty(propertyName = "reconnectInterval", propertyValue = "4000"),
        @ActivationConfigProperty(propertyName = "acknowledgeMode", propertyValue = "Auto-acknowledge") })

public class Main implements MessageListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(Main.class);

    @Override
    public void onMessage(Message message) {
        
        LOGGER.error("CWM work starts"); 

        String dataUUID = null;
        String executionID = null;
        String documentID = null;

        if (!(message instanceof TextMessage)) {
            return;
        }

        try {

            JsonFactory factory = new JsonFactory();
            JsonParser parser = factory.createParser(((TextMessage) message).getText());
            JsonToken token = null;

            while ((token = parser.nextToken()) != null) {
                if (token == JsonToken.FIELD_NAME) {
                    String fieldName = parser.getText();
                    parser.nextToken();
                    String value = parser.getText();
                    switch (fieldName) {
                        case "dataUUID":
                            dataUUID = value;
                            break;
                        case "executionID":
                            executionID = value;
                            break;
                        case "documentID":
                            documentID = value;
                            break;
                        default:
                            break;
                    }
                }
            }

            // Выполнение каких-либо действий
            // 
            // Разблокировка маршрута
            String address = "http://127.0.0.1:8080/Synergy";
            String login = "1";
            String password = "1";
            String signal = "got_agree";
            boolean isSuccess = false;

            try {
                URL url = new URL(address + "/rest/api/processes/signal?signal=" + signal + "&executionID=" + executionID + "&param1=resolution&value1=signal_is_" + signal);

                HttpURLConnection conn = (HttpURLConnection) url.openConnection();
                conn.setRequestMethod("GET");
                conn.setRequestProperty("Accept", "application/json; charset=utf-8");

                String encoded = Base64.encode((login + ":" + password).getBytes());
                conn.setRequestProperty("Authorization", "Basic " + encoded);

                String output;
                StringBuffer result = new StringBuffer();

                BufferedReader br = new BufferedReader(new InputStreamReader((conn.getInputStream())));

                while ((output = br.readLine()) != null) {
                    result.append(output);
                }

                conn.disconnect();

                factory = new JsonFactory();
                parser = factory.createParser(result.toString());
                token = null;

                while ((token = parser.nextToken()) != null) {
                    if (token == JsonToken.FIELD_NAME) {
                        String fieldName = parser.getText();
                        token = parser.nextToken();
                        if (fieldName.equals("errorCode") && parser.getText().equals("0")) {
                            isSuccess = true;
                        }
                    }
                }
            } catch (Exception exc) {
                LOGGER.error(exc.getMessage(), exc);
            }

        } catch (Exception exc) {
            LOGGER.error(exc.getMessage(), exc);
        }
    }
}