package kz.arta.synergy.astdev.custom_bp;

import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import org.codehaus.jackson.JsonNode;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.MessageDriven;
import javax.naming.NameNotFoundException;
import javax.naming.directory.AttributeModificationException;
import javax.naming.directory.InvalidAttributesException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;
import org.codehaus.jackson.type.TypeReference;

@MessageDriven(name = "CustomBP", activationConfig = {
    @ActivationConfigProperty(propertyName = "destinationType", propertyValue = "javax.jms.Queue"),
        @ActivationConfigProperty(propertyName = "destination", propertyValue = "java:jboss/queues/Integration/CustomBP"),
        @ActivationConfigProperty(propertyName = "reconnectAttempts", propertyValue = "32"),
        @ActivationConfigProperty(propertyName = "reconnectInterval", propertyValue = "4000"),
        @ActivationConfigProperty(propertyName = "acknowledgeMode", propertyValue = "Auto-acknowledge")})

public class Main implements MessageListener {

    private static final Logger LOGGER = LoggerFactory.getLogger(Main.class);

    private static enum fieldType {
        DATE, TEXTBOX, USER
    }
    
    private static enum fields {
        ID, TYPE, LABEL, KEY, VALUE
    }

    private String dataUUID = null; // идентификатор данных по форме записи реестра
    private String executionID = null;  // идентификатор блокирующего процесса
    private String documentID = null;   // идентификатор документа реестра

    @Override
    public void onMessage(Message message) {
        if (!(message instanceof TextMessage)) {
            return;
        }

        try {
            JsonFactory factory = new JsonFactory();
            JsonParser parser = factory.createParser(((TextMessage) message).getText());
            JsonToken token = null;

            while ((token = parser.nextToken()) != null) {
                if (token == JsonToken.FIELD_NAME) {
                    String fieldName = parser.getText();
                    parser.nextToken();
                    String value = parser.getText();
                    switch (fieldName) {
                        case "dataUUID":
                            dataUUID = value;
                            break;
                        case "executionID":
                            executionID = value;
                            break;
                        case "documentID":
                            documentID = value;
                            break;
                        default:
                            break;
                    }
                }
            }

            // Получение данных исходной формы (той, по которой запущен маршрут)
            URL sourceFormURL = new URL("http://127.0.0.1:8080/Synergy/rest/api/asforms/data/" + dataUUID);
            String sourceFormData = synergyApiGetString(sourceFormURL);
            
            // Получение ID пользователя
            String userID = getComponentValueByID(sourceFormData, "user1", fields.KEY);
            
            // По ID пользователя DataUUID целевой карточки
            String userCardDataUUID = getCardDataUUID(userID, "04f7809d-f44c-4a2d-950d-6aa8e6c3fea1");
            // Получение данных целевой карточки по dataUUID
            URL targetFormURL = new URL("http://127.0.0.1:8080/Synergy/rest/api/asforms/data/" + userCardDataUUID);
            String targetFormData = synergyApiGetString(targetFormURL);
            
            // Получение значений текущих дат исходной формы
            String b5b1;
            
            String t2b1;
            String t8b1;
            
//            String t18b1, t20b1, t16b1;
//            String t26b1, t24b1, t22b1;
//            String t32b1, t30b1, t28b1;
            
            // first table
            String b2b1 = getComponentValueByID(sourceFormData, "b2-b1-b1", fields.KEY);
            String b4b1 = getComponentValueByID(sourceFormData, "b4-b1-b1", fields.KEY);

            if (!b2b1.isEmpty() && !b4b1.isEmpty()) {
                updateFieldValue(targetFormData, "start-b1", fields.KEY, b2b1);
                updateFieldValue(targetFormData, "finish-b1", fields.KEY, b4b1);
                
                unlockRoute();
                return;
            }
            
            // Second table
//            String t4b1 = getComponentValueByID(sourceFormData, "t2-b1", fieldType.DATE);
//            String t6b1 = getComponentValueByID(sourceFormData, "b6-b1", fieldType.DATE);
//            String t10b1 = getComponentValueByID(sourceFormData, "t10-b1", fieldType.DATE);
//            String t12b1 = getComponentValueByID(sourceFormData, "t12-b1", fieldType.DATE);
//            
//            if (!t4b1.isEmpty() && !t6b1.isEmpty() && !t10b1.isEmpty() && !t12b1.isEmpty()) {
//                setComponentValueByID(targetFormData, "start-b1", "key", b2b1);
//                setComponentValueByID(targetFormData, "start-b1", "key", b2b1);
//                setComponentValueByID(targetFormData, "start-b1", "key", b2b1);
//                setComponentValueByID(targetFormData, "start-b1", "key", b2b1);
//                
//                unlockRoute();
//                return;
//            }

            // Разблокировка маршрута
            unlockRoute();

        } catch (Exception exc) {
            LOGGER.error(exc.getMessage(), exc);
        }
    }
 
    
    // NEW METHODS
    
    /**
     * Returns node which has specifies ID
     * @param nodesList - List of nodes
     * @param componentID - Component ID
     * @return AsNode if such exists, null otherwise
     */
    private static AsNode findNode(List<AsNode> nodesList, String componentID) {
        AsNode result = null;
        for (AsNode n : nodesList) {
            if (componentID.equals(n.getId())) {
                result = n;
                break;
            }
            if(!n.getData().isEmpty()) {
                findNode(n.getData(), componentID);
            }
        }
        return result;
    }
    
    private void updateFieldValue (String targetJsonAsString, String componentID, fields fieldName, String newFieldValue) throws AttributeModificationException, IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            JsonNode rootNode = objectMapper.readTree(targetJsonAsString);  // read the whole tree
            if (rootNode.isNull()) {
                throw new AttributeModificationException("GMP: Passed data has no JSON content");
            }
            JsonNode rootDataNode = rootNode.get("data"); // read single root 'data' node
            if (rootDataNode == null) {
                throw new AttributeModificationException("GMP: Invalid form data, root \"data\" node does not exists");
            }
            List<AsNode> dataNodesList = objectMapper.readValue(rootDataNode, new TypeReference<List<AsNode>>(){}); // map content of single root 'data' node
            
            AsNode targetNode = findNode(dataNodesList, componentID);
            if (targetNode == null) {
                throw new AttributeModificationException("GMP: Node with specified ID is not found in passed JSON");
            } else {
                switch (fieldName) {
                    case ID:
                        targetNode.setId(newFieldValue);
                        break;
                    case TYPE:
                        targetNode.setType(newFieldValue);
                        break;
                    case LABEL:
                        targetNode.setLabel(newFieldValue);
                        break;
                    case KEY:
                        targetNode.setKey(newFieldValue);
                        break;
                    case VALUE:
                        targetNode.setValue(newFieldValue);
                        break;
                    default:    // TODO
                        break;
                }
            }
        } catch (AttributeModificationException e) {
            throw e;
        }
    }
   
    /**
     * Returns user's card data UUID by form's UUID
     * @param userID - User identifier
     * @param formUUID - Forms' data UUID
     * @return Specified user's card data UUID
     */
    private static String getCardDataUUID (String userID, String formUUID) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            URL url = new URL("http://127.0.0.1:8080/Synergy/rest/api/personalrecord/forms/" + userID);
            String res = synergyApiGetString(url);
            
            List<Card> cardsList = mapper.readValue(res, new TypeReference<List<Card>>(){});
            
            for (Card c : cardsList) {
                if (formUUID.equals(c.getFormUUID())) {
                    return c.getDataUUID();
                }
            }
        } catch (Exception exc) {
            LOGGER.error(exc.getMessage(), exc);
        }
        return new String();
    }
    
    private static String getComponentValueByID(String targetJsonAsString, String componentID, fields fieldName) throws NameNotFoundException, IOException {
        // String b2b1 = getComponentValueByID(sourceFormData, "b2-b1-b1", fieldType.DATE);
        ObjectMapper objectMapper = new ObjectMapper();
        String result = null;
        
        try {
            JsonNode rootNode = objectMapper.readTree(targetJsonAsString);  // read the whole tree
            if (rootNode.isNull()) {
                throw new NameNotFoundException("GMP: Passed data has no JSON content");
            }
            JsonNode rootDataNode = rootNode.get("data"); // read single root 'data' node
            if (rootDataNode == null) {
                throw new NameNotFoundException("GMP: Invalid form data, root \"data\" node does not exists");
            }
            List<AsNode> dataNodesList = objectMapper.readValue(rootDataNode, new TypeReference<List<AsNode>>() {}); // map content of single root 'data' node

            AsNode targetNode = findNode(dataNodesList, componentID);
            if (targetNode == null) {
                throw new NameNotFoundException("GMP: Node with specified ID is not found in passed JSON");
            } else {
                switch (fieldName) {
                    case ID:
                        result = targetNode.getId();    // may be for cheking if component with such ID exists at all
                        break;
                    case TYPE:
                        result = targetNode.getType();
                        break;
                    case LABEL:
                        result = targetNode.getLabel();
                        break;
                    case KEY:
                        result = targetNode.getKey();
                        break;
                    case VALUE:
                        result = targetNode.getValue();
                        break;
                }
            } 
            return result;
        } catch (NameNotFoundException e) {
            throw e;
        }

    }
    
    
    /**
     * Route unlocking
     */
    private void unlockRoute() {
        try {
            String address = "http://127.0.0.1:8080/Synergy";
            String signal = "got_agree";
            URL url = new URL(address + "/rest/api/processes/signal?signal=" + signal + "&executionID=" + this.executionID + "&param1=resolution&value1=signal_is_" + signal);
            synergyApiGet(url);
        } catch (Exception exc) {
            LOGGER.error(exc.getMessage(), exc);
        }
    }
    
    private static JsonParser synergyApiGet(final URL requestURL) {
        String login = "111111";
        String password = "1";

        try {
            String output;

            HttpURLConnection conn = (HttpURLConnection) requestURL.openConnection();
            conn.setRequestMethod("GET");
            conn.setRequestProperty("Accept", "application/json; charset=utf-8");

            String encoded = Base64.encode((login + ":" + password).getBytes());
            conn.setRequestProperty("Authorization", "Basic " + encoded);

            BufferedReader br = new BufferedReader(new InputStreamReader((conn.getInputStream())));
            StringBuilder result = new StringBuilder();
            while ((output = br.readLine()) != null) {
                result.append(output);
            }

            conn.disconnect();

            JsonFactory factory = new JsonFactory();
            return factory.createParser(result.toString());
        } catch (Exception exc) {
            LOGGER.error(exc.getMessage(), exc);
        }

        return null;
    }
    
    private static String synergyApiGetString(final URL requestURL) {
        String login = "111111";
        String password = "1";

        try {
            String output;

            HttpURLConnection conn = (HttpURLConnection) requestURL.openConnection();
            conn.setRequestMethod("GET");
            conn.setRequestProperty("Accept", "application/json; charset=utf-8");

            String encoded = Base64.encode((login + ":" + password).getBytes());
            conn.setRequestProperty("Authorization", "Basic " + encoded);

            BufferedReader br = new BufferedReader(new InputStreamReader((conn.getInputStream())));
            StringBuilder result = new StringBuilder();
            while ((output = br.readLine()) != null) {
                result.append(output);
            }

            conn.disconnect();

            JsonFactory factory = new JsonFactory();
            return result.toString();
        } catch (Exception exc) {
            LOGGER.error(exc.getMessage(), exc);
        }

        return null;
    }
}
