/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package kz.arta.synergy.astdev.custom_bp;

import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import org.codehaus.jackson.JsonNode;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.MessageDriven;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.type.TypeReference;

@MessageDriven(name = "CustomBP", activationConfig = {
    @ActivationConfigProperty(propertyName = "destinationType", propertyValue = "javax.jms.Queue"),
        @ActivationConfigProperty(propertyName = "destination", propertyValue = "java:jboss/queues/Integration/CustomBP"),
        @ActivationConfigProperty(propertyName = "reconnectAttempts", propertyValue = "32"),
        @ActivationConfigProperty(propertyName = "reconnectInterval", propertyValue = "4000"),
        @ActivationConfigProperty(propertyName = "acknowledgeMode", propertyValue = "Auto-acknowledge")})

public class Main implements MessageListener {

    private static final Logger LOGGER = LoggerFactory.getLogger(Main.class);

    private static enum fieldType {
        DATE, TEXTBOX, USER
    }

    private String dataUUID = null; // идентификатор данных по форме записи реестра
    private String executionID = null;  // идентификатор блокирующего процесса
    private String documentID = null;   // идентификатор документа реестра

    @Override
    public void onMessage(Message message) {
        if (!(message instanceof TextMessage)) {
            return;
        }

        try {
            JsonFactory factory = new JsonFactory();
            JsonParser parser = factory.createParser(((TextMessage) message).getText());
            JsonToken token = null;

            while ((token = parser.nextToken()) != null) {
                if (token == JsonToken.FIELD_NAME) {
                    String fieldName = parser.getText();
                    parser.nextToken();
                    String value = parser.getText();
                    switch (fieldName) {
                        case "dataUUID":
                            dataUUID = value;
                            break;
                        case "executionID":
                            executionID = value;
                            break;
                        case "documentID":
                            documentID = value;
                            break;
                        default:
                            break;
                    }
                }
            }

            // Получение данных исходной формы
            URL sourceFormURL = new URL("http://127.0.0.1:8080/Synergy/rest/api/asforms/data/" + dataUUID);
            String sourceFormData = synergyApiGetString(sourceFormURL);
            
            // Получение ID пользователя
            String userID = getComponentValueByID(sourceFormData, "user1", fieldType.USER);
            
            // По ID пользователя DataUUID целевой карточки
            String userCardDataUUID = findDataUuidByUserID(userID, "04f7809d-f44c-4a2d-950d-6aa8e6c3fea1");
            
            // Получение данных целевой карточки по dataUUID
            URL targetFormURL = new URL("http://127.0.0.1:8080/Synergy/rest/api/asforms/data/" + userCardDataUUID);
            String targetFormData = synergyApiGetString(sourceFormURL);
            
            // Получение значений текущих дат исходной формы
            String b2b1, b4b1, b5b1;
            
            String t4b1, t6b1, t2b1;
            String t10b1, t12b1, t8b1;
            
            String t18b1, t20b1, t16b1;
            String t26b1, t24b1, t22b1;
            String t32b1, t30b1, t28b1;
            
            b2b1 = getComponentValueByID(sourceFormData, "b2-b1-b1", fieldType.DATE);
            b4b1 = getComponentValueByID(sourceFormData, "b4-b1", fieldType.DATE);
            b5b1 = getComponentValueByID(sourceFormData, "b5-b1", fieldType.TEXTBOX);
            
            t4b1 = getComponentValueByID(sourceFormData, "b2-b1", fieldType.DATE);

            // Разблокировка маршрута
            unlockRoute();

        } catch (Exception exc) {
            LOGGER.error(exc.getMessage(), exc);
        }
    }

//    private void postDataToCard()
    
    private void unlockRoute() {
        try {
            String address = "http://127.0.0.1:8080/Synergy";
            String signal = "got_agree";
            URL url = new URL(address + "/rest/api/processes/signal?signal=" + signal + "&executionID=" + this.executionID + "&param1=resolution&value1=signal_is_" + signal);
            synergyApiGet(url);
        } catch (Exception exc) {
            LOGGER.error(exc.getMessage(), exc);
        }
    }

    private static String findDataUuidByUserID(String userID, String formUUID) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            URL url = new URL("http://127.0.0.1:8080/Synergy/rest/api/personalrecord/forms/" + userID);
            String res = synergyApiGetString(url);
            
            List<Card> cardsList = mapper.readValue(res, new TypeReference<List<Card>>(){});
            
            for (Card c : cardsList) {
                if (formUUID.equals(c.getFormUUID())) {
                    return c.getDataUUID();
                }
            }
        } catch (Exception exc) {
            LOGGER.error(exc.getMessage(), exc);
        }
        return new String();
    }
    
    private static String searchInNode(Iterator<JsonNode> iter, String fieldName, fieldType ft) {
        String result = new String();
        // different form's component keeps data in different places
        String componentType = new String();
        if (ft == fieldType.DATE || ft == fieldType.USER) {
            componentType = "key";
        } else if (ft == fieldType.TEXTBOX) {
            componentType = "value";
        }

        while (iter.hasNext()) {
            // search data through content of child 'data' nodes
            JsonNode n = iter.next();

            if (n.has("id") && n.has(componentType)) {
                if (fieldName.equals(n.get("id").asText())) {
                    result = n.get(componentType).asText();
                }
            }
        }
        return result;
    }
    
    private static String getComponentValueByID(final String formJson, final String fieldName, fieldType ft) {
        ObjectMapper mapper = new ObjectMapper();
        String result = new String();
        String componentType = new String();
        
        try {
            JsonNode rootNode = mapper.readTree(formJson);        
            
            // gettint first level (root) 'data' node, there may be only two levels
            ArrayNode rootDN = (ArrayNode) rootNode.get("data");
            Iterator<JsonNode> rootDNIterator = rootDN.getElements();
            
            result = searchInNode(rootDNIterator, fieldName, ft);
            if (!result.isEmpty()) {
                return result;
            }
            
            Iterator<JsonNode> rootDNIterator2 = rootDN.getElements();
            while (rootDNIterator2.hasNext()) {
                ArrayNode childNode = (ArrayNode) rootDNIterator2.next().get("data");
                Iterator<JsonNode> childDNIterator = childNode.getElements();
                
                result = searchInNode(childDNIterator, fieldName, ft);
                if (!result.isEmpty()) {
                    return result;
                }
            }
            return result;
        } catch (Exception exc) {
            LOGGER.error("GMP: Invalid form data");
            LOGGER.error(exc.getMessage(), exc);
        }
        return result;
    }
        
    private static JsonParser synergyApiGet(final URL requestURL) {
        String login = "Ипатьев";
        String password = "1";

        try {
            String output;

            HttpURLConnection conn = (HttpURLConnection) requestURL.openConnection();
            conn.setRequestMethod("GET");
            conn.setRequestProperty("Accept", "application/json; charset=utf-8");

            String encoded = Base64.encode((login + ":" + password).getBytes());
            conn.setRequestProperty("Authorization", "Basic " + encoded);

            BufferedReader br = new BufferedReader(new InputStreamReader((conn.getInputStream())));
            StringBuilder result = new StringBuilder();
            while ((output = br.readLine()) != null) {
                result.append(output);
            }

            conn.disconnect();

            JsonFactory factory = new JsonFactory();
            return factory.createParser(result.toString());
        } catch (Exception exc) {
            LOGGER.error(exc.getMessage(), exc);
        }

        return null;
    }
    
    private static String synergyApiGetString(final URL requestURL) {
        String login = "Ипатьев";
        String password = "1";

        try {
            String output;

            HttpURLConnection conn = (HttpURLConnection) requestURL.openConnection();
            conn.setRequestMethod("GET");
            conn.setRequestProperty("Accept", "application/json; charset=utf-8");

            String encoded = Base64.encode((login + ":" + password).getBytes());
            conn.setRequestProperty("Authorization", "Basic " + encoded);

            BufferedReader br = new BufferedReader(new InputStreamReader((conn.getInputStream())));
            StringBuilder result = new StringBuilder();
            while ((output = br.readLine()) != null) {
                result.append(output);
            }

            conn.disconnect();

            JsonFactory factory = new JsonFactory();
            return result.toString();
        } catch (Exception exc) {
            LOGGER.error(exc.getMessage(), exc);
        }

        return null;
    }
}
