/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package kz.arta.synergy.astdev.custom_bp;

import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import org.codehaus.jackson.JsonNode;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.MessageDriven;
import javax.naming.directory.InvalidAttributesException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;
import org.codehaus.jackson.type.TypeReference;

@MessageDriven(name = "CustomBP", activationConfig = {
    @ActivationConfigProperty(propertyName = "destinationType", propertyValue = "javax.jms.Queue"),
        @ActivationConfigProperty(propertyName = "destination", propertyValue = "java:jboss/queues/Integration/CustomBP"),
        @ActivationConfigProperty(propertyName = "reconnectAttempts", propertyValue = "32"),
        @ActivationConfigProperty(propertyName = "reconnectInterval", propertyValue = "4000"),
        @ActivationConfigProperty(propertyName = "acknowledgeMode", propertyValue = "Auto-acknowledge")})

public class Main implements MessageListener {

    private static final Logger LOGGER = LoggerFactory.getLogger(Main.class);

    private static enum fieldType {
        DATE, TEXTBOX, USER
    }

    private String dataUUID = null; // идентификатор данных по форме записи реестра
    private String executionID = null;  // идентификатор блокирующего процесса
    private String documentID = null;   // идентификатор документа реестра

    @Override
    public void onMessage(Message message) {
        if (!(message instanceof TextMessage)) {
            return;
        }

        try {
            JsonFactory factory = new JsonFactory();
            JsonParser parser = factory.createParser(((TextMessage) message).getText());
            JsonToken token = null;

            while ((token = parser.nextToken()) != null) {
                if (token == JsonToken.FIELD_NAME) {
                    String fieldName = parser.getText();
                    parser.nextToken();
                    String value = parser.getText();
                    switch (fieldName) {
                        case "dataUUID":
                            dataUUID = value;
                            break;
                        case "executionID":
                            executionID = value;
                            break;
                        case "documentID":
                            documentID = value;
                            break;
                        default:
                            break;
                    }
                }
            }

            // Получение данных исходной формы (той, по которой запущен маршрут)
            URL sourceFormURL = new URL("http://127.0.0.1:8080/Synergy/rest/api/asforms/data/" + dataUUID);
            String sourceFormData = synergyApiGetString(sourceFormURL);
            
            // Получение ID пользователя
            String userID = getComponentValueByID(sourceFormData, "user1", fieldType.USER);
            
            // По ID пользователя DataUUID целевой карточки
            String userCardDataUUID = getCardDataUUID(userID, "04f7809d-f44c-4a2d-950d-6aa8e6c3fea1");
            // Получение данных целевой карточки по dataUUID
            URL targetFormURL = new URL("http://127.0.0.1:8080/Synergy/rest/api/asforms/data/" + userCardDataUUID);
            String targetFormData = synergyApiGetString(targetFormURL);
            
            // Получение значений текущих дат исходной формы
            String b5b1;
            
            String t2b1;
            String t8b1;
            
//            String t18b1, t20b1, t16b1;
//            String t26b1, t24b1, t22b1;
//            String t32b1, t30b1, t28b1;
            
            // first table
            String b2b1 = getComponentValueByID(sourceFormData, "b2-b1-b1", fieldType.DATE);
            String b4b1 = getComponentValueByID(sourceFormData, "b4-b1-b1", fieldType.DATE);

            if (!b2b1.isEmpty() && !b4b1.isEmpty()) {
                setComponentValueByID(targetFormData, "start-b1", "key", b2b1);
                setComponentValueByID(targetFormData, "finish-b1", "key", b4b1);
                
                unlockRoute();
                return;
            }
            
            // Second table
//            String t4b1 = getComponentValueByID(sourceFormData, "t2-b1", fieldType.DATE);
//            String t6b1 = getComponentValueByID(sourceFormData, "b6-b1", fieldType.DATE);
//            String t10b1 = getComponentValueByID(sourceFormData, "t10-b1", fieldType.DATE);
//            String t12b1 = getComponentValueByID(sourceFormData, "t12-b1", fieldType.DATE);
//            
//            if (!t4b1.isEmpty() && !t6b1.isEmpty() && !t10b1.isEmpty() && !t12b1.isEmpty()) {
//                setComponentValueByID(targetFormData, "start-b1", "key", b2b1);
//                setComponentValueByID(targetFormData, "start-b1", "key", b2b1);
//                setComponentValueByID(targetFormData, "start-b1", "key", b2b1);
//                setComponentValueByID(targetFormData, "start-b1", "key", b2b1);
//                
//                unlockRoute();
//                return;
//            }

            // Разблокировка маршрута
            unlockRoute();

        } catch (Exception exc) {
            LOGGER.error(exc.getMessage(), exc);
        }
    }

    private void setComponentValueByID (String targetJsonAsString, String componentID, String fieldName, String newFieldValue) throws InvalidAttributesException {
        ObjectMapper mapper = new ObjectMapper();
        
        try {
            
            JsonNode rootNode = mapper.readTree(targetJsonAsString);
            
            // getting first level (root) 'data' node, there may be only two levels
            ArrayNode rootDN = (ArrayNode) rootNode.get("data");
            Iterator<JsonNode> rootDNIterator = rootDN.getElements();   // all objects of first 'data'
            
            // searching for field value in root 'data' node and setting new value if found
            JsonNode node = searchInNode2(rootDNIterator, componentID, fieldName);
            // setting node value
            if (node != null) {
                setValueInNode(node, componentID, newFieldValue, componentID);
                return;
            }

            // root 'data' value does not contain the expected value, search in second (last possible) 'data'
            Iterator<JsonNode> rootDNIterator2 = rootDN.getElements(); // all objects of first 'data'
            while (rootDNIterator2.hasNext()) {
                ArrayNode childNode = (ArrayNode) rootDNIterator2.next().get("data"); // get next 'data'

                if (childNode != null) {
                    Iterator<JsonNode> childDNIterator = childNode.getElements();
                    node = searchInNode2(childDNIterator, componentID, fieldName);
                }

            }
            
            if (node != null) {
                setValueInNode(node, componentID, newFieldValue, componentID);
            } else {
            throw new InvalidAttributesException("GMP: Target form field cannot be updated");
            }
            
        } catch (Exception exc) {
            LOGGER.error(exc.getMessage(), exc);
        }
    }
    
    private void unlockRoute() {
        try {
            String address = "http://127.0.0.1:8080/Synergy";
            String signal = "got_agree";
            URL url = new URL(address + "/rest/api/processes/signal?signal=" + signal + "&executionID=" + this.executionID + "&param1=resolution&value1=signal_is_" + signal);
            synergyApiGet(url);
        } catch (Exception exc) {
            LOGGER.error(exc.getMessage(), exc);
        }
    }

    // get user's card data uuid by formuuid
    private static String getCardDataUUID (String userID, String formUUID) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            URL url = new URL("http://127.0.0.1:8080/Synergy/rest/api/personalrecord/forms/" + userID);
            String res = synergyApiGetString(url);
            
            List<Card> cardsList = mapper.readValue(res, new TypeReference<List<Card>>(){});
            
            for (Card c : cardsList) {
                if (formUUID.equals(c.getFormUUID())) {
                    return c.getDataUUID();
                }
            }
        } catch (Exception exc) {
            LOGGER.error(exc.getMessage(), exc);
        }
        return new String();
    }
    
    private static void setValueInNode (JsonNode node, String componentID, String newFieldValue, String componentFieldName) throws InvalidAttributesException {
        if (node == null) {
            throw new InvalidAttributesException("JsonNode cannot be null");
        }
        
        try {
            ObjectNode objectNode = (ObjectNode) node;
            objectNode.put(componentFieldName, newFieldValue);
        } catch (Exception exc) {
            throw exc;
        }
    }
    
    private static String searchInNode(Iterator<JsonNode> iter, String fieldName, fieldType ft) {
        String result = new String();
        // different form's component keeps data in different places
        String componentType = new String();
        if (ft == fieldType.DATE || ft == fieldType.USER) {
            componentType = "key";
        } else if (ft == fieldType.TEXTBOX) {
            componentType = "value";
        }

        while (iter.hasNext()) {
            // search data through content of child 'data' nodes
            JsonNode n = iter.next();

            if (n.has("id") && n.has(componentType)) {
                if (fieldName.equals(n.get("id").asText())) {
                    result = n.get(componentType).asText();
                }
            }
        }
        return result;
    }
    
    private static JsonNode searchInNode2(Iterator<JsonNode> iter, String componentID, String componentFieldName) {

        while (iter.hasNext()) {
            // search data through content of child 'data' nodes
            JsonNode n = iter.next();

            if (n.has("id") && n.has(componentFieldName)) {
                if (componentID.equals(n.get("id").asText())) {
                    return n;
                }
            }
        }
        return null;
    }
    
    private static String getComponentValueByID(String formJson, String fieldName, fieldType ft) {
        ObjectMapper mapper = new ObjectMapper();
        String result = new String();
        
        try {
            JsonNode rootNode = mapper.readTree(formJson);        
            
            // getting first level (root) 'data' node, there may be only two levels
            ArrayNode rootDN = (ArrayNode) rootNode.get("data");
            Iterator<JsonNode> rootDNIterator = rootDN.getElements();
            
            // searching for field value in root 'data' node
            result = searchInNode(rootDNIterator, fieldName, ft);
            if (!result.isEmpty()) {
                return result;
            }
            
            // root 'data' value does not contain the expected value, search in second (last possible) 'data'
            Iterator<JsonNode> rootDNIterator2 = rootDN.getElements(); // 'reset' iterator (create new one)
            while (rootDNIterator2.hasNext()) {
                ArrayNode childNode = (ArrayNode) rootDNIterator2.next().get("data");
                Iterator<JsonNode> childDNIterator = childNode.getElements();
                
                result = searchInNode(childDNIterator, fieldName, ft);
                if (!result.isEmpty()) {
                    return result;
                }
            }
            return result;
        } catch (Exception exc) {
            LOGGER.error("GMP: Invalid form data");
            LOGGER.error(exc.getMessage(), exc);
        }
        return result;
    }
        
    private static JsonParser synergyApiGet(final URL requestURL) {
        String login = "Ипатьев";
        String password = "1";

        try {
            String output;

            HttpURLConnection conn = (HttpURLConnection) requestURL.openConnection();
            conn.setRequestMethod("GET");
            conn.setRequestProperty("Accept", "application/json; charset=utf-8");

            String encoded = Base64.encode((login + ":" + password).getBytes());
            conn.setRequestProperty("Authorization", "Basic " + encoded);

            BufferedReader br = new BufferedReader(new InputStreamReader((conn.getInputStream())));
            StringBuilder result = new StringBuilder();
            while ((output = br.readLine()) != null) {
                result.append(output);
            }

            conn.disconnect();

            JsonFactory factory = new JsonFactory();
            return factory.createParser(result.toString());
        } catch (Exception exc) {
            LOGGER.error(exc.getMessage(), exc);
        }

        return null;
    }
    
    private static String synergyApiGetString(final URL requestURL) {
        String login = "Ипатьев";
        String password = "1";

        try {
            String output;

            HttpURLConnection conn = (HttpURLConnection) requestURL.openConnection();
            conn.setRequestMethod("GET");
            conn.setRequestProperty("Accept", "application/json; charset=utf-8");

            String encoded = Base64.encode((login + ":" + password).getBytes());
            conn.setRequestProperty("Authorization", "Basic " + encoded);

            BufferedReader br = new BufferedReader(new InputStreamReader((conn.getInputStream())));
            StringBuilder result = new StringBuilder();
            while ((output = br.readLine()) != null) {
                result.append(output);
            }

            conn.disconnect();

            JsonFactory factory = new JsonFactory();
            return result.toString();
        } catch (Exception exc) {
            LOGGER.error(exc.getMessage(), exc);
        }

        return null;
    }
}
