/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package kz.arta.synergy.astdev.custom_bp;

import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.MessageDriven;

@MessageDriven(name = "CustomBP", activationConfig = {
    @ActivationConfigProperty(propertyName = "destinationType", propertyValue = "javax.jms.Queue"),
        @ActivationConfigProperty(propertyName = "destination", propertyValue = "java:jboss/queues/Integration/CustomBP"),
        @ActivationConfigProperty(propertyName = "reconnectAttempts", propertyValue = "32"),
        @ActivationConfigProperty(propertyName = "reconnectInterval", propertyValue = "4000"),
        @ActivationConfigProperty(propertyName = "acknowledgeMode", propertyValue = "Auto-acknowledge")})

public class Main implements MessageListener {
    
    private enum fieldType {
        DATE, TEXTBOX
    }

    private static final Logger LOGGER = LoggerFactory.getLogger(Main.class);

    @Override
    public void onMessage(Message message) {

        LOGGER.error("CWM work starts");

        String dataUUID = null; // идентификатор данных по форме записи реестра
        String executionID = null;  // идентификатор блокирующего процесса
        String documentID = null;   // идентификатор документа реестра

        if (!(message instanceof TextMessage)) {
            return;
        }

        try {
            JsonFactory factory = new JsonFactory();
            JsonParser parser = factory.createParser(((TextMessage) message).getText());
            JsonToken token = null;

            while ((token = parser.nextToken()) != null) {
                if (token == JsonToken.FIELD_NAME) {
                    String fieldName = parser.getText();
                    parser.nextToken();
                    String value = parser.getText();
                    switch (fieldName) {
                        case "dataUUID":
                            dataUUID = value;
                            break;
                        case "executionID":
                            executionID = value;
                            break;
                        case "documentID":
                            documentID = value;
                            break;
                        default:
                            break;
                    }
                }
            }

            // Получение данных исходной формы
            URL getFormDataURL = new URL("http://127.0.0.1:8080/Synergy/rest/api/asforms/data/" + dataUUID);
            JsonParser sourceFormData = synergyApiGet(getFormDataURL);
            
            // Получение значений текущих дат исходной формы
            String b2b1, b4b1, b5b1;
            
            String t4b1, t6b1, t2b1;
            String t10b1, t12b1, t8b1;
            
            String t18b1, t20b1, t16b1;
            String t26b1, t24b1, t22b1;
            String t32b1, t30b1, t28b1;
            
            b2b1 = getDateKeyByFieldName(sourceFormData, "b2-b1", fieldType.DATE);
            b4b1 = getDateKeyByFieldName(sourceFormData, "b4-b1", fieldType.DATE);
            b5b1 = getDateKeyByFieldName(sourceFormData, "b5-b1", fieldType.TEXTBOX);
            
            LOGGER.info(b2b1 + " " + b4b1 + " " + b5b1);
            
            // Получение данных целевой карточки
            

            // Разблокировка маршрута""
            String address = "http://127.0.0.1:8080/Synergy";
            String signal = "got_agree";
            URL url = new URL(address + "/rest/api/processes/signal?signal=" + signal + "&executionID=" + executionID + "&param1=resolution&value1=signal_is_" + signal);
            synergyApiGet(url);

        } catch (Exception exc) {
            LOGGER.error(exc.getMessage(), exc);
        }
    }

    /**
     * */
    private static String getDateKeyByFieldName(final JsonParser formJson, final String fieldName, fieldType fieldT) {
        String value = new String();
        try {
            while (!formJson.isClosed()) {
                if (JsonToken.FIELD_NAME.equals(formJson.nextToken())) {
                    if ("id".equals(formJson.getCurrentName()) && fieldName.equals(formJson.nextTextValue())) {
                        switch (fieldT) {
                            case DATE:
                                formJson.nextToken();
                                formJson.nextToken();
                                formJson.nextToken();
                                formJson.nextToken();
                                formJson.nextToken();
                                value = formJson.nextTextValue();
                                break;
                            case TEXTBOX:
                                formJson.nextToken();
                                formJson.nextToken();
                                formJson.nextToken();
                                formJson.nextToken();
                                value = formJson.nextTextValue();
                                break;
                        }
                    }

                }
            }
        } catch (Exception exc) {
            LOGGER.error(exc.getMessage(), exc);
        }
        return value;
    }
    
    private static JsonParser synergyApiGet(final URL requestURL) {
        String login = "Ипатьев";
        String password = "1";

        try {
            String output;

            HttpURLConnection conn = (HttpURLConnection) requestURL.openConnection();
            conn.setRequestMethod("GET");
            conn.setRequestProperty("Accept", "application/json; charset=utf-8");

            String encoded = Base64.encode((login + ":" + password).getBytes());
            conn.setRequestProperty("Authorization", "Basic " + encoded);

            BufferedReader br = new BufferedReader(new InputStreamReader((conn.getInputStream())));
            StringBuilder result = new StringBuilder();
            while ((output = br.readLine()) != null) {
                result.append(output);
            }

            conn.disconnect();

            JsonFactory factory = new JsonFactory();
            return factory.createParser(result.toString());
        } catch (Exception exc) {
            LOGGER.error(exc.getMessage(), exc);
        }

        return null;
    }
}
