//
//  Facade+Forget.swift
//  kt
//
//  Created by Assylkhan Rakhatov on 10.02.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation
extension Facade {
  func forgetPassword(params: [String: AnyObject], onError: String -> Void, onSuccess: String -> Void) {
    request(Router.Forget(params)).responseSwiftyJSON(completionHandler: { (req, resp, json, error) in
      Router.globalLog.debug(req)
      Router.globalLog.debug(json)
      if let error = error {
        Router.globalLog.error(error.debugDescription)
        onError(error.localizedDescription)
      } else {
        Router.globalLog.debug(resp)
        if json["error_code"].stringValue == "0" {
          onSuccess(json["email"].stringValue)
        } else {
          Router.globalLog.error(json["error"].stringValue)
          onError(json["error"].stringValue)
        }
      }
    })
    //    get_abonent_device_list
  }
}
