//
//  DeviceSettings.swift
//  kt
//
//  Created by Assylkhan Rakhatov on 23.02.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation

class DeviceSettings {
  var abonentName = ""
  var internetLogin = ""
  var message: String?
  var device = "7153520143"
  var linkTypeId = "761499955"
  var accountUserId = "3711925"
  var limitInfo = "-9999999(0)"
  var turboInfo = "2"
  var mac = "Не установлен"
  var isExternalTraffic = "1"
  var packetTypeName = "Megaline Start"
  var packetTypeId = "4399"
  var isBlock = "F"
  var parentalControlOuterrcodeout:Int? = 1
  var parentalControlOutmsg = "Услуга не установлена"
  var megalineTariffPlanList = [[String: AnyObject]]()
  var promisedPayment: String = ""
  var promisedPaymentStatus: Int?
  var staticIp: String?
  var staticIpStatus: String = "0"
  
  init(json: JSON) {
    abonentName = json["abn_name"].stringValue
    internetLogin = json["internet_login"].stringValue
    message = json["msg"].string
    device = json["device"].stringValue
    linkTypeId = json["link_type_id"].stringValue
    accountUserId = json["account_user_id"].stringValue
    limitInfo = json["limit_info"].stringValue
    turboInfo = json["turbo_info"].stringValue
    mac = json["mac"].stringValue
    isExternalTraffic = json["is_external_traffic"].stringValue
    packetTypeName = json["packet_type_name"].stringValue
    packetTypeId = json["packet_type_id"].stringValue
    isBlock = json["is_block"].stringValue
    parentalControlOuterrcodeout = json["parental_control_outerrcodeout"].intValue
    parentalControlOutmsg = json["parental_control_outmsg"].stringValue
    
    if let megalineTariffPlanList = json["megaline_tariff_plan_list"].arrayObject {
      for item in megalineTariffPlanList {
        let tariffPlan = item as! [String: AnyObject]
        self.megalineTariffPlanList.append(tariffPlan)
      }
    }
  }
  
}
