//
//  ServiceCell.swift
//  kt
//
//  Created by Alexandr Zalutskiy on 19.01.15.
//  Copyright (c) 2015 Alexandr Zalutskiy. All rights reserved.
//

import UIKit

class ServiceCell: UITableViewCell {
  @IBOutlet private weak var iconView: UIImageView!
  @IBOutlet private weak var nameLabel: UILabel!
    @IBOutlet weak var backgroundImage: UIImageView!
    @IBOutlet weak var extraLabel: UILabel!
    @IBOutlet weak var divider: UIView!
    
  func setService(servicesItem : ServiceItem, withRow row: Int) {
    
    //contentView.backgroundColor = UIColor(red: 1.0, green: 0.44, blue: 0.18, alpha: 1.0)
    iconView.image = UIImage(named: servicesItem.service!.imageName)
    nameLabel.setTextAndSizeToFit(servicesItem.name)
    
    selectedBackgroundView = UIView(frame: contentView.frame)
    //selectedBackgroundView!.backgroundColor = UIColor(red: 0.0, green: 0.44, blue: 0.18, alpha: 1.0)
    //selectedBackgroundView!.alpha = 0.8
    
    if ( servicesItem.imageUrl != nil ) {
        ImageLoader.sharedLoader.imageForUrl(servicesItem.imageUrl!) { (image, url) in
            if ( image != nil ) {
                self.backgroundImage.image = image?.imageWithRenderingMode(.AlwaysOriginal)
            } else {
                self.backgroundImage.backgroundColor = UIColor.lightGrayColor()
            }
        }
        self.iconView.alpha = 0.0
        self.nameLabel.textColor = UIColor.blackColor()
        self.divider.alpha = 0.0
//        selectedBackgroundView!.backgroundColor = UIColor.clearColor()
    } else {
        self.iconView.alpha = 0.0
        self.divider.alpha = 1.0
        //self.nameLabel.textColor = UIColor.whiteColor()
        
        //contentView.backgroundColor = servicesItem.service!.colorForRow(row)
//        selectedBackgroundView!.backgroundColor = servicesItem.service!.colorForRow(row)
        self.backgroundImage.addConstraint(NSLayoutConstraint(item: self.backgroundImage, attribute: .Height, relatedBy: .Equal, toItem: nil, attribute: .NotAnAttribute, multiplier: 1.0, constant: 0))
    }
    
    self.extraLabel.text = servicesItem.description
  }
  
  override func setSelected(selected: Bool, animated: Bool) {
    
    let block : () -> Void = {
      if selected {
        self.contentView.alpha = 0.8
      } else {
        self.contentView.alpha = 1.0
      }
    }
    
    if animated {
      UIView.animateWithDuration(0.2, animations: block)
    } else {
      block()
    }
  }
  
  override func setHighlighted(highlighted: Bool, animated: Bool) {
    let block : () -> Void = {
      if highlighted {
        self.contentView.alpha = 0.8
      } else {
        self.contentView.alpha = 1.0
      }
    }
    
    if animated {
      UIView.animateWithDuration(0.2, animations: block)
    } else {
      block()
    }
  }
}
