//
//  VIPAdditional.swift
//  kt
//
//  Created by neox on 09.11.17.
//  Copyright © 2017 SimpleCode. All rights reserved.
//

import Foundation

class VIPAdditional: UITableViewCell {
    
    var vc : ServiceVIPTableViewController!
    var indexPath : NSIndexPath!
    @IBOutlet weak var uiSwitch: UISwitch!
    @IBOutlet weak var label: UILabel!
    @IBOutlet weak var labelPrice: UILabel!
    @IBOutlet weak var labelUnit: UILabel!
    
    override func awakeFromNib() {
        super.awakeFromNib()
        
        self.selectionStyle = UITableViewCellSelectionStyle.None
        
        ///setOn(false)
        uiSwitch.addTarget(self, action: #selector(VIPAdditional.switchChanged(_:)), forControlEvents: UIControlEvents.ValueChanged)
        
        labelUnit.text = LS("tenge_per_month")
    }
    
    func switchChanged(sender: UISwitch) {
        //vc.additionalSwitch(indexPath, isOn: sender.on)
        //setSelected(sender.on, animated: true)
        vc.setRowSelected(indexPath, isOn: sender.on)
    }
    
    func setOn(bool : Bool) {
        uiSwitch.setOn(bool, animated: true)
    }
    
    func setPrice(price: Int) {
        labelPrice.text = String(price)
    }
    
}
