//
//  VIPCell.swift
//  kt
//
//  Created by neox on 07.11.17.
//  Copyright © 2017 SimpleCode. All rights reserved.
//

import Foundation
import DLRadioButton

class VIPCell : UITableViewCell {
    
    var vc : ServiceVIPTableViewController!
    var price = VIPPrices.VIP
    
    @IBOutlet weak var layoutHeader: UIView!
    @IBOutlet weak var labelTitle: UILabel!
    @IBOutlet weak var labelPrice: UILabel!
    @IBOutlet weak var labelTengeMonth: UILabel!
    @IBOutlet weak var labelAudience: UILabel!
    
    @IBOutlet weak var labelInternet: UILabel!
    @IBOutlet weak var labelInternet1: UILabel!
    @IBOutlet weak var labelInternet2: UILabel!
    @IBOutlet weak var labelInternet3: UILabel!
    
    @IBOutlet weak var labelPremiumTV: UILabel!
    @IBOutlet weak var labelPremiumTV1: UILabel!
    @IBOutlet weak var labelPremiumTV2: UILabel!
    @IBOutlet weak var labelPremiumTV3: UILabel!
    @IBOutlet weak var labelPremiumTV4: UILabel!
    
    @IBOutlet weak var labelSupertelephone: UILabel!
    @IBOutlet weak var labelSupertelephone1: UILabel!
    @IBOutlet weak var labelSupertelephone2: UILabel!
    @IBOutlet weak var labelSupertelephone3: UILabel!
    
    @IBOutlet weak var buttonOption1: DLRadioButton!
    @IBOutlet weak var buttonOption2: DLRadioButton!
//    @IBOutlet var buttons: [DLRadioButton]!
    
    
    override func awakeFromNib() {
        super.awakeFromNib()
        
        self.labelTitle.text = LS("service_vip")
        
        self.selectionStyle = UITableViewCellSelectionStyle.None
        
        labelPrice.text = "\(price) "
        labelTengeMonth.text = LS("tenge_per_month")
        labelAudience.text = LS("service_vip_audience")
        
        labelInternet.text = LS("service_safe_internet").uppercaseString
        labelInternet1.text = LS("service_fast_internet")
        labelInternet2.text = LS("service_kaspersky")
        labelInternet3.text = LS("service_parent_control")
        
        labelPremiumTV.text = LS("service_premium_tv").uppercaseString
        labelPremiumTV1.text = LS("service_premium_tv_1")
        labelPremiumTV2.text = LS("service_premium_tv_2")
        labelPremiumTV3.text = LS("service_premium_tv_3")
        labelPremiumTV4.text = LS("service_premium_tv_4")
        
        labelSupertelephone.text = LS("service_supertelephone").uppercaseString
        labelSupertelephone1.text = LS("service_supertelephone_1")
        labelSupertelephone2.text = LS("service_supertelephone_2")
        labelSupertelephone3.text = LS("service_supertelephone_3")
        
        buttonOption2.selected = true
        
        buttonOption1.setTitle(LS("service_vip_option_1"), forState: .Normal)
        buttonOption2.setTitle(LS("service_vip_option_2"), forState: .Normal)
        
        //buttonOption1.setButtonWidth()
        //buttonOption2.setButtonWidth()
        buttonOption1.addTarget(self, action: #selector(VIPCell.radioButtonClick(_:)), forControlEvents: UIControlEvents.TouchUpInside)
        buttonOption2.addTarget(self, action: #selector(VIPCell.radioButtonClick(_:)), forControlEvents: UIControlEvents.TouchUpInside)

    }
    
    func radioButtonClick(sender: DLRadioButton) {
        if ( sender == buttonOption1 ) {
            vc.setBoolOptionRussianPhone(true)
        } else if ( sender == buttonOption2 ) {
            vc.setBoolOptionRussianPhone(false)
        }
    }
    
    override func setSelected(selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)
        
        if ( selected ) {
            self.contentView.layer.borderColor = UIColor.ocean().CGColor
            self.contentView.layer.borderWidth = 3
            layoutHeader.backgroundColor = UIColor.ocean()
        } else {
            self.contentView.layer.borderColor = UIColor.clearColor().CGColor
            self.contentView.layer.borderWidth = 0
            layoutHeader.backgroundColor = UIColor.sky()
        }
    }
    
//    @IBAction func radioButtonSelect(sender: DLRadioButton) {
//        for btn in self.buttons {
//            btn.selected = (btn == sender) ? true: false
//        }
//    }
    
//    override func setHighlighted(highlighted: Bool, animated: Bool) {
//        super.setHighlighted(highlighted, animated: animated)
//        
//        if ( highlighted ) {
//            self.contentView.layer.borderColor = UIColor.ocean().CGColor
//            self.contentView.layer.borderWidth = 2
//            layoutHeader.backgroundColor = UIColor.ocean()
//            
//        } else {
//            self.contentView.layer.borderColor = UIColor.clearColor().CGColor
//            self.contentView.layer.borderWidth = 0
//            layoutHeader.backgroundColor = UIColor.sky()
//        }
//    }
    
}

