//
//  VIPMax.swift
//  kt
//
//  Created by neox on 13.11.17.
//  Copyright © 2017 SimpleCode. All rights reserved.
//

import Foundation

class VIPMax : UITableViewCell {
    
    var vc: ServiceVIPTableViewController!
    var price = VIPPrices.VIP_MAX
    
    @IBOutlet weak var layoutHeader: UIView!
    @IBOutlet weak var buttonPlus: UILabel!
    @IBOutlet weak var labelService: UILabel!
    @IBOutlet weak var labelPrice: UILabel!
    @IBOutlet weak var labelUnit: UILabel!
    @IBOutlet weak var labelAudience: UILabel!
    @IBOutlet weak var labelOption1: UILabel!
    @IBOutlet weak var labelOption2: UILabel!
    @IBOutlet weak var labelOption3: UILabel!
    @IBOutlet weak var labelOption4: UILabel!
    @IBOutlet weak var labelOption5: UILabel!
    @IBOutlet weak var labelOption6: UILabel!
    @IBOutlet weak var labelOption7: UILabel!
    @IBOutlet weak var labelOption8: UILabel!
    @IBOutlet weak var labelOption9: UILabel!
    
    override func awakeFromNib() {
        super.awakeFromNib()
        
        self.selectionStyle = UITableViewCellSelectionStyle.None
        
        labelService.text = LS("service_vip_max")
        labelAudience.text = LS("service_vip_max_audience")
        labelPrice.text = "+\(price)"
        labelUnit.text = LS("tenge_per_month")
        labelOption1.text = LS("service_vip_max_option_1")
        labelOption2.text = LS("service_vip_max_option_2")
        labelOption3.text = LS("service_vip_max_option_3")
        labelOption4.text = LS("service_vip_max_option_4")
        labelOption5.text = LS("service_vip_max_option_5")
        labelOption6.text = LS("service_vip_max_option_6")
        labelOption7.text = LS("service_vip_max_option_7")
        labelOption8.text = LS("service_vip_max_option_8")
        labelOption9.text = LS("service_vip_max_option_9")
    }
    
    override func setSelected(selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)
        
        if ( selected ) {
            self.contentView.layer.borderColor = UIColor.ocean().CGColor
            self.contentView.layer.borderWidth = 3
            layoutHeader.backgroundColor = UIColor.ocean()
            buttonPlus.textColor = UIColor.ocean()
        } else {
            self.contentView.layer.borderColor = UIColor.clearColor().CGColor
            self.contentView.layer.borderWidth = 0
            layoutHeader.backgroundColor = UIColor.sky()
            buttonPlus.textColor = UIColor.sky()
        }
    }
    
}
