//
// Created by Alexander Zalutskiy on 12.08.15.
// Copyright (c) 2015 Alexandr Zalutskiy. All rights reserved.
//

import Foundation

extension Facade {
    
    static var serverId: Int? = nil
    static var accountId: Int? = nil
    static var guid: String? = nil
    
    func getGuid(onSuccess: (() -> Void)? = nil, onError: ((NSError) -> Void)? = nil) {
        
        if Facade.accessToken == nil || Facade.clientId == nil {
            notificationCenter.postNotification(UserNeedAuthNotification)
            return
        }
        
        let params = [
            "access_token": Facade.accessToken!,
            "client_id": Facade.clientId!
        ]
        
        request(.POST, "https://telecom.kz/api/guid/get_guid.json", parameters: params, encoding: .JSON).responseJSON { (resp) in
            Router.globalLog.debug(resp.request!)
            switch resp.result {
            case .Failure(let error):
                Router.globalLog.error(error.debugDescription)
                onError?(error)
                break
            case .Success(let json):
                Router.globalLog.debug(resp.response!)
                Router.globalLog.debug(json)
                Facade.serverId = json["server_id"] as? Int
                Facade.accountId = json["account_id"] as? Int
                Facade.guid = "\(Facade.serverId!)-\(Facade.accountId!)"
                onSuccess?()
                break
            }
        }
    }
}
