//
//  Facade+Service.swift
//  kt
//
//  Created by Alexandr Zalutskiy on 28.01.15.
//  Copyright (c) 2015 Alexandr Zalutskiy. All rights reserved.
//

import Foundation

let FacadeItemsSuccess = "FacadeItemsSuccess"
let FacadeItemSuccess = "FacadeItemSuccess"

extension Facade {
	func getServices(service : Service, forCity city: City) {
		var route : Router
		
		switch service {
		case .Package, .Actions:
			route = Router.PackagesListForCity(city.id)
		case .Internet:
			route = Router.InternetListForCity(city.id)
		case .Tv:
			route = Router.TvListForCity(city.id)
		case .Software:
			route = Router.RentalListForCity(city.id)
		case .Phone:
			route = Router.PhoneListForCity(city.id)
		case .Hosting:
			route = Router.HostingListForCity(city.id)
		}
		
		request(route).responseSwiftyJSON {
			(req, resp, json, error) in
      Router.globalLog.debug(req)
      Router.globalLog.debug(json)
      if let error = error {
        Router.globalLog.error(error.debugDescription)
      } else {
        Router.globalLog.debug(resp)
      }
			var points = [ServiceItem]()
			
			for (_, subJson) in json {
				points.append(ServiceItem(json: subJson))
			}
			
			self.notificationCenter.postNotificationName(
				FacadeItemsSuccess,
				object: self,
				userInfo: ["items" : points]
			)
		}
	}
	
	func getServiceItem(service: Service, withId id: Int, forCity city: City) {
		var route : Router
		
		switch service {
		case .Package, .Actions:
			route = Router.Packages(id, city.id)
		case .Internet:
			route = Router.Internet(id, city.id)
		case .Tv:
			route = Router.Tv(id, city.id)
		case .Software:
			route = Router.Rental(id, city.id)
		case .Phone:
			route = Router.Phone(id, city.id)
		case .Hosting:
			route = Router.Hosting(id, city.id)
		}
		
		request(route).responseSwiftyJSON {
			(req, resp, json, error) in
      Router.globalLog.debug(req)
      Router.globalLog.debug(json)
      if let error = error {
        Router.globalLog.error(error.debugDescription)
      } else {
        Router.globalLog.debug(resp)
      }
			let point = ServiceItem(fullJson: json)
			
			self.notificationCenter.postNotificationName(
				FacadeItemSuccess,
				object: self,
				userInfo: ["item" : point]
			)
		}
	}
  
  func getLanding(params: [String: AnyObject], onSuccess: (ServiceItem) -> Void, onError: (error: String) -> Void, onFinish: () -> Void) {
    request(Router.GetLanding(params)).responseSwiftyJSON(completionHandler: { (req, resp, json, error) in
      
      Router.globalLog.debug(req)
      Router.globalLog.debug(json)
      if let error = error {
        Router.globalLog.error(error.debugDescription)
        onError(error: error.localizedDescription)
      } else {
        Router.globalLog.debug(resp)
        if let error = json["error"].dictionary {
          Router.globalLog.error(error)
          onError(error: "\(error.description)")
        } else if let error = json["error"].string {
          Router.globalLog.error(error)
          onError(error: error)
        } else {
          let serviceItem = ServiceItem(fullJson: json)
          onSuccess(serviceItem)
          self.notificationCenter.postNotificationName(
            FacadeItemSuccess,
            object: self,
            userInfo: ["item" : serviceItem]
          )
        }
      }
        
    })
  }
}
