//
// Created by Alexander Zalutskiy on 12.08.15.
// Copyright (c) 2015 Alexandr Zalutskiy. All rights reserved.
//

import Foundation

class AbonentInfoManager: NSObject {
    
	struct NotificationNames {
		static let Update = "varate"
		static let Error = "error"
	}
  
	var abonentInfo: AbonentInfo?

	override private init() {
		super.init()
	}
  
	class var sharedInstance: AbonentInfoManager {
		struct Shared {
			static let sharedInstance : AbonentInfoManager = AbonentInfoManager()
		}
		return Shared.sharedInstance
	}
  
	func updateUserInfo() {
		NSNotificationCenter.defaultCenter().addObserver(self, selector: #selector(AbonentInfoManager.updateUserInfoSuccess(_:)), name: Facade.AbonentInfoNotificationNames.Success, object: Facade.sharedInstance())
		NSNotificationCenter.defaultCenter().addObserver(self, selector: #selector(AbonentInfoManager.updateUserInfoError(_:)), name: Facade.AbonentInfoNotificationNames.Error, object: Facade.sharedInstance())
		Facade.sharedInstance().getAbonentInfo()
	}
  
	func updateUserInfoSuccess(notification: NSNotification) {
		abonentInfo = notification.userInfo![FacadeNotificationObjectKey] as? AbonentInfo
		NSNotificationCenter.defaultCenter().postNotificationName(NotificationNames.Update, object: self)
		NSNotificationCenter.defaultCenter().removeObserver(self)
	}
  
	func updateUserInfoError(notification: NSNotification) {
		NSNotificationCenter.defaultCenter().postNotificationName(NotificationNames.Error, object: self, userInfo: notification.userInfo!)
		NSNotificationCenter.defaultCenter().removeObserver(self)
	}
}
