//
//  BotResult.swift
//  kt
//
//  Created by neox on 12.07.17.
//  Copyright © 2017 SimpleCode. All rights reserved.
//

import UIKit

class BotResult: NSObject, NSCoding {

    internal var nodes : [BotNode]?
    internal var count : Int?
    internal var status : String?
    internal var type : Int = 0
    internal var date = NSDate()
    internal var uuid : String
    
    override init() {
        self.uuid = NSUUID().UUIDString
        super.init()
    }
    
    func compare(botResult:BotResult) -> Bool {
        if botResult.uuid.compare(self.uuid) == .OrderedSame {
            return true
        }
        return false
    }
    
    @objc required init?(coder aDecoder: NSCoder) {
        nodes = aDecoder.decodeObjectForKey("nodes") as! [BotNode]!
        count = aDecoder.decodeObjectForKey("count") as! Int?
        status = aDecoder.decodeObjectForKey("status") as! String?
        type = aDecoder.decodeObjectForKey("type") as! Int
        date = aDecoder.decodeObjectForKey("date") as! NSDate
        uuid = aDecoder.decodeObjectForKey("uuid") as! String
    }
    
    @objc func encodeWithCoder(aCoder: NSCoder) {
        aCoder.encodeObject(nodes, forKey: "nodes")
        aCoder.encodeObject(count, forKey: "count")
        aCoder.encodeObject(status, forKey: "status")
        aCoder.encodeObject(type, forKey: "type")
        aCoder.encodeObject(date, forKey: "date")
        aCoder.encodeObject(uuid, forKey: "uuid")
    }
    
}

