//
//  AccountServices.swift
//  kt
//
//  Created by Bibol Bolat on 5/10/17.
//  Copyright © 2017 ArtaSoft. All rights reserved.
//

import Foundation

struct AccountServices {
    
    let telephones: [String]
    let altel4G: [String]
    let megalineIdNets: [MegalineIdNet]
    let idTvOnlines: [IdTvOnline]
    let idPhone: [IdPhone]
    let additionalInfo: AdditionalInfo
    
    typealias SimpleMap = [String: AnyObject]
    
    static func decode(json: [String : AnyObject]) -> AccountServices? {
        
        guard
            let telephones = json["telephone"] as? [String],
            let altel4G = json["altel_4g"] as? [String],
            let additionalInfo = AdditionalInfo.decode(json["additional_info"] as! SimpleMap),
            let megalineIdNetArray = json["megaline_idnet"] as? [SimpleMap],
            let idTvOnlineArray = json["idtv_online"] as? [SimpleMap],
            let idPhoneArray = (json["idphone"] as? [SimpleMap])
            else { return nil }
        
        var megalineIdNets: [MegalineIdNet] = []
        var idTvOnlines: [IdTvOnline] = []
        var idPhones: [IdPhone] = []
        
        
        for index in megalineIdNetArray.indices {
            megalineIdNets.append(MegalineIdNet.decode(megalineIdNetArray[index])!)
        }
        
        for index in idTvOnlineArray.indices {
            idTvOnlines.append(IdTvOnline.decode(idTvOnlineArray[index])!)
        }
        
        for index in idPhoneArray.indices {
            idPhones.append(IdPhone.decode(idPhoneArray[index])!)
        }
        
        return AccountServices(telephones: telephones, altel4G: altel4G, megalineIdNets: megalineIdNets, idTvOnlines: idTvOnlines, idPhone: idPhones, additionalInfo: additionalInfo)
    }
}

struct MegalineIdNet {
    
    let name: String
    let device: String
    let linkID: String
    
    static func decode(json: [String : AnyObject]) -> MegalineIdNet? {
        
        guard
            let name = json["PACKET_TYPE_NAME"] as? String,
            let device = (json["DEVICE"] as? String),
            let linkID = (json["LINK_TYPE_ID"] as? String)
            else { return nil }
        
        return MegalineIdNet(name: name, device: device, linkID: linkID)
    }
    //    "LINK_TYPE_ID" : "810943065",
    //    "LIMIT_INFO" : "-1500(0)",
    //    "MAC" : "Не установлен",
    //    "DEVICE" : "7278177224",
    //    "TURBO_INFO" : "0",
    //    "PACKET_TYPE_NAME" : "ID Net Base Turbo",
    //    "IS_BLOCK" : "F",
    //    "INTERNET_LOGIN" : "Fvbh1988",
    //    "ACCOUNT_USR_ID" : "10374281",
    //    "ABN_NAME" : "АО \"КАЗАХТЕЛЕКОМ\"- ТЕСТОВЫЙ 2",
    //    "IS_EXTERNAL_TRAFFIC" : "2",
    //    "MSG" : null,
    //    "PACKET_TYPE_ID" : "22380"
}

struct IdTvOnline {
    
    let name: String
    let device: String
    let typeID: Int
    
    static func decode(json: [String : AnyObject]) -> IdTvOnline? {
        
        guard
            let name = json["CONNECT_TYPE_NAME"] as? String,
            let device = json["DEVICE"] as? String,
            let typeID = json["CONNECT_TYPE_ID"] as? Int
            else { return nil }
        
        return IdTvOnline(name: name, device: device, typeID: typeID)
    }
    //    "CONNECT_TYPE_NAME" : "ID TV Online Bonus",
    //    "DEVICE" : "17.17.8177224.50701.50703",
    //    "DEVICE_GROUP_ID" : "41",
    //    "LINK_ID" : "4793134",
    //    "DEVICE_GROUP_NAME" : "ID TV",
    //    "CONNECT_TYPE_ID" : "400001"
}

struct IdPhone {
    
    let name: String
    let number: String
    
    static func decode(json: [String : AnyObject]) -> IdPhone? {
        guard
            let name = json["bwks_id"] as? String,
            let number = (json["number"] as? String)
            else { return nil }
        
        return IdPhone(name: name, number: number)
    }
    //    "idphone": [
    //    "bwks_id": "175020114@sip.telecom.kz",
    //    "number": "7279711234"
}

struct AdditionalInfo {
    
    let megogoLink: String?
    
    static func decode(json: [String : AnyObject]) -> AdditionalInfo? {
        guard
            let megogolink: String? = json["megogo_link"] as? String
            else { return nil }
        
        return AdditionalInfo(megogoLink: megogolink)
    }
    //    "additional_info" : {
    //    "megogo_link" : null
}


