//
//  PaymentCreateOrderRequest.swift
//  kt
//
//  Created by Assylkhan Rakhatov on 23.06.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation

class PaymentCreateOrderRequest {
  var payType: String?
  var email: String?
  var guidOrPhone: String?
  var amount: String?
  var lang: String?
  var validationMessage = ""
  
  init(payType: String? = nil, email: String? = nil, guidOrPhone: String? = nil, amount: String? = nil, lang: String?) {
    self.payType = payType
    self.email = email
    self.guidOrPhone = guidOrPhone
    self.amount = amount
    self.lang = lang
  }
  
  func validateFields() -> Bool {
    var isValid = true
    if payType.isNilOrEmpty || email.isNilOrEmpty || guidOrPhone.isNilOrEmpty || amount.isNilOrEmpty || lang.isNilOrEmpty {
      isValid = false
      validationMessage = LS("error_fill_all_fields")
    } else if !isValidEmail(email) {
      isValid = false
      validationMessage = validationMessage == "" ? LS("online_payment.label.incorrect_email") : "\(validationMessage); \(LS("online_payment.label.incorrect_email"))"
    } else if guidOrPhone == "" {
      isValid = false
      validationMessage = validationMessage == "" ? LS("online_payment.label.incorrect_guid_or_phone") : "\(validationMessage); \(LS("online_payment.label.incorrect_guid_or_phone"))"
    } else if amount == "" {
      isValid = false
      validationMessage = validationMessage == "" ? LS("online_payment.label.incorrect_payment_summ") : "\(validationMessage); \(LS("online_payment.label.incorrect_payment_summ"))"
    }
    return isValid
  }
  
  var params: [String: AnyObject] {
    return ["pay_type": self.payType!,
            "email": self.email!,
            self.payType!: self.guidOrPhone!,
            "amount": self.amount!,
            "lang": self.lang!]
  }
}
