//
//  MainKnowedgeViewController.swift
//  kt
//
//  Created by neox on 14.09.17.
//  Copyright © 2017 SimpleCode. All rights reserved.
//

import UIKit

class MainKnowedgeViewController: UIViewController {
    
    @IBOutlet weak var tableview: UITableView!
    
    var knowedgeList : [KnowedgeModel] = []
    
    override func viewDidLoad() {
        
        super.viewDidLoad()
        
        self.tableview.estimatedRowHeight = 44.0;
        self.tableview.rowHeight = UITableViewAutomaticDimension;
        //self.tableview.separatorStyle = .None
        
        Facade.sharedInstance().getCategories({ (knowedgeList: [KnowedgeModel]) in
            self.knowedgeList = knowedgeList
            self.tableview.reloadData()
            }, onError: { (error: String) in
                AlertViewUtil.showErrorAlert(error, vc: self)
        }) {
            
        }
    }
    
    func tableView(tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return knowedgeList.count
    }
    
    func tableView(tableView: UITableView, cellForRowAtIndexPath indexPath: NSIndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCellWithIdentifier("Cell", forIndexPath: indexPath) as! MainKnowedgeTableViewCell
        cell.label.text = knowedgeList[indexPath.row].name
        if knowedgeList[indexPath.row].type == "category" {
            cell.backgroundColor = UIColor(red: 236.0 / 255.0, green: 236.0 / 255.0, blue: 236.0 / 255.0, alpha: 1.0)
            cell.accessoryType = UITableViewCellAccessoryType.None
        } else {
            cell.backgroundColor = UIColor.whiteColor()
            cell.accessoryType = UITableViewCellAccessoryType.DisclosureIndicator
        }
        return cell
    }
    
    func tableView(tableView: UITableView, didSelectRowAtIndexPath indexPath: NSIndexPath) {
        if let id = knowedgeList[indexPath.row].id {
            let vc = self.storyboard!.instantiateViewControllerWithIdentifier("KnowedgeQuestionsViewController") as! KnowedgeQuestionsViewController
            vc.id = id
            vc.screenName = knowedgeList[indexPath.row].name
            self.navigationController!.pushViewController(vc, animated: true)
        }
    }
    
    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }
}
