//
//  CashAndPaymentsViewController.swift
//  kt
//
//  Created by Assylkhan Rakhatov on 15.05.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation
import UIKit

class CashAndPaymentsViewController: ViewControllerWithMenu {
    
    private var viewControllers: [UIViewController]!
    //  private var pagingMenuController: PagingMenuController?
    //  private let pagingMenuOptions = PagingMenuOptions()
    var pageMenu : CAPSPageMenu?
    var parameters: [CAPSPageMenuOption]?
    //  var controllerArray : [UIViewController] = []
    
    override func viewWillAppear(animated: Bool) {
        super.viewWillAppear(animated)
        configureBlueNavbar()
        localize()
    }
    
    // MARK: view life cycle
    override func viewDidLoad() {

        super.viewDidLoad()
        
        self.navigationItem.title = "Мои счета"

        settingPaging()
        
        createViewControllers()
        
        pageMenu = CAPSPageMenu(viewControllers: viewControllers, frame: CGRectMake(0.0, 0.0, self.view.frame.width, self.view.frame.height), pageMenuOptions: parameters)
        
        self.view.addSubview(pageMenu!.view)
        
        pageMenu?.view.translatesAutoresizingMaskIntoConstraints = false
        let views = ["page_menu": pageMenu!.view]
        self.view.addConstraints(NSLayoutConstraint.constraintsWithVisualFormat("H:|[page_menu]|", options: [], metrics: nil, views: views))
        self.view.addConstraints(NSLayoutConstraint.constraintsWithVisualFormat("V:|[page_menu]|", options: [], metrics: nil, views: views))
    }
    
    func settingPaging() {
        parameters = [
            .UnselectedMenuItemLabelColor(UIColor.whiteColor().colorWithAlphaComponent(0.7)),
            .MenuItemSeparatorWidth(1),
            .UseMenuLikeSegmentedControl(true),
            .MenuItemSeparatorPercentageHeight(0.8),
            .ScrollMenuBackgroundColor(Color.DashboardBlueColor),
            .MenuItemSeparatorColor(UIColor.whiteColor().colorWithAlphaComponent(0.5)),
            .MenuItemFont(UIFont.systemFontOfSize(12)),
            .MenuHeight(44),
            CAPSPageMenuOption.SelectionIndicatorHeight(0)
        ]
    }
    
    func createViewControllers() {
        
        viewControllers = [UIViewController]()
        
        let publishedCashesViewController = storyboard!.instantiateViewControllerWithIdentifier("PublishedCashes") as! PublishedCashesViewController
        publishedCashesViewController.localize()
        publishedCashesViewController.cashAndPaymentsViewController = self
        viewControllers.append(publishedCashesViewController)
        
        let paymentsHistoryViewController = storyboard!.instantiateViewControllerWithIdentifier("PaymentHistory") as! PaymentsHistoryViewController
        paymentsHistoryViewController.cashAndPaymentsViewController = self
        paymentsHistoryViewController.localize()
        viewControllers.append(paymentsHistoryViewController)
    }

}

extension CashAndPaymentsViewController {
    override var localizedId: String {
        return "cash_and_payments"
    }
}
