//
//  UICreateIDTVViewController.swift
//  kt
//
//  Created by Admin on 29.12.16.
//  Copyright © 2016 SimpleCode. All rights reserved.
//

import Foundation
import UIKit

class UICreateIDTVViewController: UIViewController, UITableViewDataSource, UITableViewDelegate, UIListBoxViewControllerDelegate {
    
    @IBOutlet var tableView: UITableView!
    @IBOutlet var button: UIButton!
    
    var IDTVPlans : [IDTVPlan] = []
    var cellData : TitleValueCellData!
    
    //MARK: - view lifecycle
    
    override func viewDidLoad() {
        super.viewDidLoad()
        button.setTitle(LS("idtv_createWindows_buttonTitle"), forState: .Normal)
        configureNavigationBar()
        sendRequestIDTVPlans()
    }
    
    //MARK: - private functions
    
    func configureNavigationBar() {
        let titleLabel = UILabel(frame: CGRect(x: 0, y: 0, width: 150, height: 36))
        titleLabel.textColor = .whiteColor()
        titleLabel.font = UIFont.systemFontOfSize(15)
        titleLabel.textAlignment = .Center
        titleLabel.text = LS("idtv_createWindow_navigationTitle")
        self.title = titleLabel.text
        //self.configureNavigationBar()
    }
    
    func sendRequestIDTVPlans() {
        self.processRequest(true)
        Facade.sharedInstance().getListIDTVPlans({ (errorString) in
            AlertViewUtil.showAlert(errorString)
            }, onSuccess: { (plans) in
                self.IDTVPlans = plans
                if (plans.count > 0) {
                    self.updateCellData(plans[0])
                }
            }) {
                //OnComplete
                self.processRequest(false)
        }
    }
    
    func sendRequestCreateIDTV(plan : IDTVPlan) {
        self.processRequest(true)
        Facade.sharedInstance().createIDTV(plan.in_connect_type_id!, onError: { (errorString) in
            AlertViewUtil.showAlert(errorString)
            }, onSuccess: { (successString) in
                AlertViewUtil.showAlert(successString)
                self.back()
            }) {
                //OnComplete
                self.processRequest(false)
        }
    }
    
    func showSelectPlan() {
        let vc = storyboard?.instantiateViewControllerWithIdentifier("listBoxViewControllerIdentifier") as! UIListBoxViewController
        vc.listBoxItems = IDTVPlans
        vc.title = LS("idtv_createWindow_selectPlan_navigationTitle")
        vc.delegate = self
        vc.tag = ListBoxType.services.rawValue
        showViewController(vc, sender: self)
    }
    
    func updateCellData(plan : IDTVPlan) {
        cellData = TitleValueCellData(title: LS("idtv_createWindow_lblTitle").uppercaseString, value: plan.name!, onClick: {
            self.showSelectPlan()
        })
        cellData.object = plan
        tableView.reloadData()
    }
    
    //MARK: - IBActions
    
    @IBAction func createAction(sender: AnyObject) {
        let plan = cellData.object as! IDTVPlan
        sendRequestCreateIDTV(plan)
    }
    
}

//MARK: UIListBoxViewControllerDelegate
extension UICreateIDTVViewController {
    
    func didSelectItem(listBoxViewController: UIListBoxViewController, selectedListBoxItem: ListBoxItemProtocol, numberIndex: NSNumber) {
        let index = numberIndex.integerValue
        updateCellData(IDTVPlans[index])
    }
    
}

// UITableViewDelegate
extension UICreateIDTVViewController {
    
    func tableView(tableView: UITableView, didSelectRowAtIndexPath indexPath: NSIndexPath) {
        let cell = tableView.cellForRowAtIndexPath(indexPath)
        cell?.selected = false
        cellData.onClick()
    }
    
}

// UITableViewDataSource
extension UICreateIDTVViewController {
    
    func tableView(tableView: UITableView, willDisplayCell cell: UITableViewCell, forRowAtIndexPath indexPath: NSIndexPath) {
        (cell as? RBCreationFieldTableCell)?.textField.setBottomBorder(Color.GrayTableCellSeparator)
    }
    
    func tableView(tableView: UITableView, cellForRowAtIndexPath indexPath: NSIndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCellWithIdentifier(cellData.cellType.reuseIdentifier, forIndexPath: indexPath) as! UITitleValueTableViewCell
        cell.fillWithCellData(cellData)
        return cell
    }
    
    func tableView(tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return cellData == nil ? 0 : 1
    }
    
}
