//
//  HelpViewController.swift
//  kt
//
//  Created by Assylkhan Rakhatov on 01.02.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation
import UIKit

class HelpViewController: KeyboardedViewController {
    
    @IBOutlet var needHelpLabel: UILabel!
    @IBOutlet var recallLabel: UILabel!
    @IBOutlet var nameField: GreyRoundFrameTextField!
    @IBOutlet var phoneField: GreyRoundFrameTextField!
    @IBOutlet var cancelButton: ModalButton!
    @IBOutlet var sendButton: ModalButton!
    var originalOrigin: CGPoint?
    
    private func registerForKeyboardAction() {
        let notificationCenter = NSNotificationCenter.defaultCenter()
        notificationCenter.addObserver(self, selector: #selector(HelpViewController.keyboardDidShow(_:)),
                                       name:UIKeyboardWillShowNotification, object: nil)
        notificationCenter.addObserver(self, selector: #selector(HelpViewController.keyboardWillBeHidden(_:)),
                                       name: UIKeyboardWillHideNotification, object: nil)
    }
    
    // MARK: Keyboard action
    func keyboardDidShow(notification: NSNotification) {
        let info = notification.userInfo!
        var kbRect = info[UIKeyboardFrameBeginUserInfoKey]!.CGRectValue
        kbRect = view.convertRect(kbRect, fromView: nil)
        view.frame.origin = CGPoint(x: view.frame.origin.x, y: originalOrigin!.y - 30)
    }
    
    func keyboardWillBeHidden(notification: NSNotification) {
        view.frame.origin = CGPoint(x: view.frame.origin.x, y: originalOrigin!.y)
    }
    
    override func viewDidLoad() {
        super.viewDidLoad()
        registerForKeyboardAction()
        view.addGestureRecognizer(tapGestureRecognizer)
    }
    
    deinit {
        NSNotificationCenter.defaultCenter().removeObserver(self)
    }
    
    override func viewWillAppear(animated: Bool) {
        originalOrigin = view.frame.origin
        localizeSubviews()
    }
    
    func localizeSubviews() {
        needHelpLabel.localizeWithParent(self, localizedId: "need_help")
        recallLabel.localizeWithParent(self, localizedId: "we_recall")
        nameField.localizeWithParent(self, localizedId: "FIO")
        phoneField.placeholder = "+7()"
        cancelButton.setTitle(LocalizedString("cancel"), forState: .Normal)
        sendButton.setTitle(LocalizedString("send"), forState: .Normal)
    }
    
    @IBAction func cancel_TouchUpInside(sender: UIButton) {
        ModalWindow.sharedInstance().hideLoadingView()
    }
    
    @IBAction func send_TouchUpInside(sender: UIButton) {
        //    Facade.sharedInstance().sendCallbackRequest(1, serviceId: 1, fio: nameField.text!, phoneNumber: phoneField.text!, email: "email")
    }
    
}

extension HelpViewController {
    override var localizedId: String {
        return "help"
    }
}
