//
//  ServiceCalculatorViewController.swift
//  kt
//
//  Created by neox on 02.11.17.
//  Copyright © 2017 SimpleCode. All rights reserved.
//

import Foundation
import UIKit

class ServiceCalculatorViewController: UIViewController, UITableViewDelegate, UITableViewDataSource {
    
    var serviceItem : ServiceItem?
    
    @IBOutlet weak var scrollView: UIScrollView!
    @IBOutlet weak var serviceImage: UIImageView!
    @IBOutlet weak var servicePriceView: UILabel!
    @IBOutlet weak var serviceNameView: UILabel!
    @IBOutlet weak var labelWhatIsNew: UILabel!
    @IBOutlet weak var labelSafeInternet: UILabel!
    @IBOutlet weak var labelFastInternet: UILabel!
    @IBOutlet weak var labelKaspersky: UILabel!
    @IBOutlet weak var labelParentControl: UILabel!
    @IBOutlet weak var labelPremiumTV: UILabel!
    @IBOutlet weak var labelPremiumTV1: UILabel!
    @IBOutlet weak var labelPremiumTV2: UILabel!
    @IBOutlet weak var labelPremiumTV3: UILabel!
    @IBOutlet weak var labelPremiumTV4: UILabel!
    @IBOutlet weak var labelServiceOptions: UILabel!
    @IBOutlet weak var tableViewServiceOption: UITableView!
    var tableData = ["Almaty", "Aqtau", "Astana", "Atyrau"]
    
    
    override func loadView() {
        super.loadView()
        
        self.title = serviceItem?.name
        
        self.scrollView.hidden = true
        requestService()
        
    }
    
    override func viewDidLoad() {
        super.viewDidLoad()
        self.tableViewServiceOption.dataSource = self
        self.tableViewServiceOption.delegate = self
        
    }
    
    func load() {
        self.scrollView.hidden = false
        
        
        ImageLoader.sharedLoader.imageForUrl((self.serviceItem?.image.absoluteString)!) { (image, url) in
            if ( image != nil ) {
                self.serviceImage.image = image?.imageWithRenderingMode(.AlwaysOriginal)
            } else {
                self.serviceImage.backgroundColor = UIColor.lightGrayColor()
            }
        }
        //
        self.serviceNameView.text = self.serviceItem?.seoTitle?.uppercaseString
        self.servicePriceView.text = (self.serviceItem?.rates[0].price)!// + " " + LS("service_price_per_month_unit")
        self.labelWhatIsNew.text = LS("service_what_is_in_package")
        self.labelSafeInternet.text = LS("service_safe_internet").uppercaseString
        
        self.labelFastInternet.text = LS("service_fast_internet")
        self.labelKaspersky.text = LS("service_kaspersky")
        self.labelParentControl.text = LS("service_parent_control")
        
        self.labelPremiumTV.text = LS("service_premium_tv")
        self.labelPremiumTV1.text = LS("service_premium_tv_1")
        self.labelPremiumTV2.text = LS("service_premium_tv_2")
        self.labelPremiumTV3.text = LS("service_premium_tv_3")
        self.labelPremiumTV4.text = LS("service_premium_tv_4")
        
        self.labelServiceOptions.text = ""
    }
    
    func requestService() {
        let params: [String: AnyObject] = ["service_id": (serviceItem?.id)!, "type": "landing" ]
        
        Facade.sharedInstance().getLanding(params, onSuccess: { (serviceItem) in
            self.serviceItem = serviceItem
            self.load()
            }, onError: { (error) in
                print(error)
            }, onFinish: {
        })
    }
    
    @IBAction func buttonAddClicked(sender: UIButtonRoundedBlue) {
    }
    
    @IBAction func buttonCallbackClicked(sender: UIButtonRoundedGray) {
    }
    
}

extension ServiceCalculatorViewController {
    
    func numberOfSectionsInTableView(tableView: UITableView) -> Int {
        return 1//servicesList.count
    }
    
    func tableView(tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return self.tableData.count
    }
    
//    func tableView(tableView: UITableView, didDeselectRowAtIndexPath indexPath: NSIndexPath) {
//        if let cell = tableView.cellForRowAtIndexPath(indexPath) {
//            cell.accessoryType = .None
//        }
//    }
    
//    func tableView(tableView: UITableView, didSelectRowAtIndexPath indexPath: NSIndexPath) {
//        if let cell = tableView.cellForRowAtIndexPath(indexPath) {
//            cell.accessoryType = .Checkmark
//            
//        }
//    }
    
    func tableView(tableView: UITableView, cellForRowAtIndexPath indexPath: NSIndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCellWithIdentifier("cellServiceOption", forIndexPath: indexPath) as UITableViewCell
        let text = tableData[indexPath.row]
        cell.textLabel?.text = text
        return cell
    }


}
