//
//  SettingsSwitchFieldTableViewCell.swift
//  kt
//
//  Created by Alexander Zalutskiy on 21.08.15.
//  Copyright © 2015 Alexandr Zalutskiy. All rights reserved.
//

import UIKit
protocol SettingsSwitchSellDelegate:class {
  func onChangeSwitch(state: Bool, cell: SettingSwitchFieldTableViewCell)
}

class SettingSwitchFieldTableViewCell: UITableViewCell {
  
  @IBOutlet weak var _textLabel: UILabel!
  @IBOutlet weak var switchAdv: UISwitch!
  var vc: LKSettingsViewController!
  var fieldTitle: String!
  //  var delegate: SettingsSwitchSellDelegate!
  
  func fillCell(text: String, fieldTitle: String, vc: LKSettingsViewController) {
    self.vc = vc
    self.fieldTitle = fieldTitle
    vc.params[fieldTitle] = switchAdv.on
    //    if !vc.switchFields.keys.contains(title) {
    //      vc.switchFields[title] = switchAdv
    //    }
    
  }
  
  // MARK: Setters
  
  func setTitle(text: String) {
    _textLabel.text = text
  }
  
  func setSwitch(en: Bool){
    switchAdv.setOn(en, animated: false)
  }
  
  func setAvailable(av: Bool){
    switchAdv.userInteractionEnabled = av
  }
  
  func getSwitch() -> Bool{
    return switchAdv.on.boolValue
  }
  
  override func awakeFromNib() {
    super.awakeFromNib()
    switchAdv.addTarget(self, action: #selector(SettingSwitchFieldTableViewCell.stateChanged(_:)), forControlEvents: UIControlEvents.ValueChanged)
  }
  
  func stateChanged(switchAdv: UISwitch){
    self.vc.params[fieldTitle] = switchAdv.on
    self.vc.isChangedSettings()
    //    delegate.onChangeSwitch(getSwitch(), cell: self)
  }
  
  override func setSelected(selected: Bool, animated: Bool) {
    super.setSelected(selected, animated: animated)
    
    // Configure the view for the selected state
  }
  
}
