//
//  UIRepairBureauTableViewCell.swift
//  kt
//
//  Created by Admin on 05.12.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation

class RBCellData : CellData {
    override internal var cellType: CellType { return CellType.RBCell}
    
    internal var headerText : String = ""
    internal var valueText : String = ""
    internal var footerText : String = ""
    
    init(fullDamage: FullDamage) {
        super.init()
        headerText = fullDamage.date ?? ""
        valueText = ("\(fullDamage.assetNumber ?? "") \(fullDamage.deviceGroup ?? "")").uppercaseString
        footerText = "\(fullDamage.damageId ?? "")(\(fullDamage.status ?? ""))"
    }
    
    init(claim: Claim) {
        super.init()
        headerText = claim.date ?? ""
        valueText = ("\(claim.assetNumber ?? "")").uppercaseString
        footerText = "\(claim.claimId ?? "")(\(claim.status ?? ""))"
    }
    
    convenience init(fullDamage: FullDamage, onClick : () -> Void) {
        self.init(fullDamage: fullDamage)
        self.onClick = onClick
    }
    
    convenience init(claim: Claim, onClick : () -> Void) {
        self.init(claim: claim)
        self.onClick = onClick
    }
}


class UIRBTableViewCell : UIBaseTableViewCell {
    @IBOutlet weak var headerLabel: UILabel!
    @IBOutlet weak var footerLabel: UILabel!
    @IBOutlet weak var valueLabel: UILabel!
    
    override func awakeFromNib() {
        super.awakeFromNib()
        removeLeftMargin()
        valueLabel.textColor = Color.DashboardBlueColor
        headerLabel.textColor = Color.MyServicesCellGrayColor
        footerLabel.textColor = Color.MyServicesCellGrayColor
    }
    
    override func fillWithCellData(cellData: CellData) {
        super.fillWithCellData(cellData)
        let myCellData = cellData as! RBCellData
        headerLabel.setTextAndSizeToFit(myCellData.headerText)
        footerLabel.setTextAndSizeToFit(myCellData.footerText)
        valueLabel.setTextAndSizeToFit(myCellData.valueText)
    }
    
}
