//
//  VIPAdditionalStepper.swift
//  kt
//
//  Created by neox on 14.11.17.
//  Copyright © 2017 SimpleCode. All rights reserved.
//

import Foundation

class VIPAdditionalStepper : UITableViewCell {
    
    var vc : ServiceVIPTableViewController!
    var indexPath : NSIndexPath!
    @IBOutlet weak var uiSwitch: UISwitch!
    @IBOutlet weak var label: UILabel!
    @IBOutlet weak var labelPrice: UILabel!
    @IBOutlet weak var labelUnit: UILabel!
    @IBOutlet weak var stepper: UIStepper!
    @IBOutlet weak var labelAmount: UILabel!
    
    override func awakeFromNib() {
        super.awakeFromNib()
        
        self.selectionStyle = UITableViewCellSelectionStyle.None
        
        ///setOn(false)
        uiSwitch.addTarget(self, action: #selector(VIPAdditionalStepper.switchChanged(_:)), forControlEvents: UIControlEvents.ValueChanged)
        stepper.addTarget(self, action: #selector(VIPAdditionalStepper.stepperChanged(_:)), forControlEvents: UIControlEvents.ValueChanged)
        
        labelUnit.text = LS("tenge_per_month")
        
    }
    
    func switchChanged(sender: UISwitch) {
        //vc.additionalSwitch(indexPath, isOn: sender.on)
        //setSelected(sender.on, animated: true)
        vc.setRowSelected(indexPath, isOn: sender.on)
    }
    
    func stepperChanged(sender: UIStepper) {
        vc.setAmount(indexPath.row, amount: Int(sender.value))
        labelAmount.text = String(Int(sender.value))
    }
    
    func setOn(bool : Bool) {
        uiSwitch.setOn(bool, animated: true)
    }
    
    func setPrice(price: Int) {
        labelPrice.text = String(price)
    }
    
    func setAmount(value: Int) {
        stepper.value = Double(value)
        labelAmount.text = String(value)
    }
    
}
