//
//  VIPTotal.swift
//  kt
//
//  Created by neox on 09.11.17.
//  Copyright © 2017 SimpleCode. All rights reserved.
//

import Foundation

class VIPTotal : UITableViewCell {
    
    var vc : ServiceVIPTableViewController!
    
    @IBOutlet weak var labelSelected: UILabel!
    @IBOutlet weak var labelSelectedServices: UILabel!
    @IBOutlet weak var labelTotal: UILabel!
    @IBOutlet weak var labelTotalPrice: UILabel!
    @IBOutlet weak var labelTenge: UILabel!
    
    override func awakeFromNib() {
        super.awakeFromNib()
        
        labelTotal.text = LS("service_vip_total_text")
        labelSelected.text = LS("service_vip_total_selected")
        labelTenge.text = LS("tenge")
        labelSelectedServices.text = ""
        
        if ( vc != nil ) {
            updateTotal()
        }
        
    }
    
    func updateTotal() {
        let text = String(vc.getTotalPrice())
        print (text)
        labelTotalPrice.text = text
        
        labelSelectedServices.text = vc.getServicesTotal()
    }
    
}
