//
//  ServicePaymentFieldCell.swift
//  kt
//
//  Created by Assylkhan Rakhatov on 01.06.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation
import UIKit

class ServicePaymentFieldCell : UITableViewCell, UITextFieldDelegate {
  @IBOutlet weak var titleLabel: UILabel!
  @IBOutlet weak var textField: UITextField!
  var textValue = ""
  var vc: PaymentForProviderViewController!
  var clickableCellValue: String = notClickableCell {
    didSet {
      if clickableCellValue == clickableCell {
        self.accessoryType = .DisclosureIndicator
      } else {
        //self.selectionStyle = .None
        self.accessoryType = .None
      }
    }
  }
  
  override func awakeFromNib() {
    super.awakeFromNib()
    textField.addTarget(self, action: #selector(ServicePaymentFieldCell.textChanged(_:)), forControlEvents: UIControlEvents.EditingChanged)
    textField.applyUITextFieldStyle()
    textField.delegate = self
  }
  
  func textChanged(textField: UITextField) {
    vc.params[textValue] = textField.text
  }
  
  func cellSelected() {
    if textValue == "bank" {
      vc.performSegueWithIdentifier("showBanks", sender: textValue)
    } else if textValue == "card_type" {
      vc.performSegueWithIdentifier("showCardTypes", sender: textValue)
    }
  }
  
    
    
  func fillTextFields(text: String) {
    switch text {
    case "bank":
      textField.text = vc.selectedBank?.name
      break
    case "card_type":
      textField.text = vc.selectedCardType?.name
      break
    default:
      break
    }
  }
  
  func fillCell(text: String, vc: PaymentForProviderViewController, clickableCellValue: String) {
    self.clickableCellValue = clickableCellValue
    self.vc = vc
    textValue = text
    fillTextFields(text)
    if text == "bank" || text == "card_type" {
      textField.userInteractionEnabled = false
    }
    if textValue == "amount" {
      textField.keyboardType = UIKeyboardType.NumberPad
      selectionStyle = UITableViewCellSelectionStyle.None
    }
    titleLabel.localizeWithParent(self, localizedId: text)
  }
  
}

// UITextFieldDelegate
extension ServicePaymentFieldCell {
  
  func textFieldShouldReturn(textField: UITextField) -> Bool {
    self.endEditing(true)
    return false
  }
}

extension ServicePaymentFieldCell: LocalizedParent {
  var localizedId: String {
    return "service_payment"
  }
}
