//
//  Knowedge.swift
//  kt
//
//  Created by neox on 18.09.17.
//  Copyright © 2017 SimpleCode. All rights reserved.
//

import Foundation

extension Facade {
    
    func getCategories(onSuccess: [KnowedgeModel] -> Void, onError: String -> Void, onFinish: () -> Void) {
        request(.GET, "https://telecom.kz/api/knowledge/get_categories.json", parameters: nil, encoding: .URL).responseSwiftyJSON(completionHandler: { (req, resp, json, error) in
            if let error = error {
                Router.globalLog.error(error.debugDescription)
                onError(error.localizedDescription)
            } else {
                Router.globalLog.debug(resp)
                Router.globalLog.debug(json)
                var knowedgeList : [KnowedgeModel] = []
                if let items = json["items"].array {
                    for n in items {
                        let categoryModel = KnowedgeModel()
                        categoryModel.name = n["name"].string
                        categoryModel.type = "category"
                        knowedgeList.append(categoryModel)
                        if let subList = n["subcategories"].array {
                            for s in subList {
                                let subcategoryModel = KnowedgeModel()
                                subcategoryModel.id = s["id"].int
                                subcategoryModel.name = s["name"].string
                                subcategoryModel.type = "subcategory"
                                knowedgeList.append(subcategoryModel)
                            }
                        }
                    }
                    onSuccess(knowedgeList)
                } else {
                    onError("Error to get subcategories")
                }
            }
        })
    }
    
    func getAnswers(onSuccess: [AnswerModel] -> Void, onError: String -> Void, onFinish: () -> Void, categoryID: Int) {
        request(.GET, "https://telecom.kz/api/knowledge/get_subcategory_questions.json?category_id=\(categoryID)", parameters: nil, encoding: .URL).responseSwiftyJSON(completionHandler: { (req, resp, json, error) in
            if let error = error {
                Router.globalLog.error(error.debugDescription)
                onError(error.localizedDescription)
            } else {
                Router.globalLog.debug(resp)
                Router.globalLog.debug(json)
                var answerList : [AnswerModel] = []
                if let items = json["items"].array {
                    for n in items {
                        let answerModel = AnswerModel()
                        answerModel.question = n["question"].string
                        if let subList = n["answers"].array {
                            for s in subList {
                                answerModel.answer = s["answer"].string
                                answerList.append(answerModel)
                            }
                        }
                    }
                    onSuccess(answerList)
                } else {
                    onError("Error to get answers")
                }
            }
        })
    }
    
    func getVideo(onSuccess: [VideoModel] -> Void, onError: String -> Void, onFinish: () -> Void) {
        request(.GET, "https://telecom.kz/api/knowledge/get_videos.json", parameters: nil, encoding: .URL).responseSwiftyJSON(completionHandler: { (req, resp, json, error) in
            if let error = error {
                Router.globalLog.error(error.debugDescription)
                onError(error.localizedDescription)
            } else {
                Router.globalLog.debug(resp)
                Router.globalLog.debug(json)
                var videoList : [VideoModel] = []
                if let items = json["items"].array {
                    for n in items {
                        let videoModel = VideoModel()
                        videoModel.label = n["name"].string!
                        videoModel.youtube_id = n["youtube_id"].string!
                        videoList.append(videoModel)
                    }
                    onSuccess(videoList)
                } else {
                    onError("Error to get videos")
                }
            }
        })
    }
}
    
