//
//  ServiceCallbackRequest.swift
//  kt
//
//  Created by Assylkhan Rakhatov on 02.06.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation

class ServiceCallbackRequest {
    
    var cityId: String?
    var serviceId: Int?
    var fullName: String?
    var phone: String?
    var email: String?
    var type: Int?
    var isEmailValid = true
    var isPhoneValid = true
    var isBlank = false
    var validationMessage = ""
    var formType: Int?
    var userComment: String?
    
    init(cityId: String? = nil, serviceId: Int? = nil, fullName: String? = nil, phone: String? = nil, email: String? = nil, type: Int? = nil, formType: Int? = nil, userComment: String? = nil) {
        self.cityId = cityId
        self.serviceId = serviceId
        self.fullName = fullName
        self.phone = phone
        self.email = email
        self.type = type
        self.formType = formType
        self.userComment = userComment
    }
    
    func validateFields() -> Bool {
        var isValid = true
        //    if cityId == nil || serviceId == nil || fullName.isNilOrEmpty || phone.isNilOrEmpty || type == nil {
        //      isValid = false
        //      validationMessage = LS("error_fill_all_fields")
        //    } else {
        //
        //      if phone?.characters.count < 10 || phone?.characters.count > 10 {
        //        isValid = false
        //        validationMessage = validationMessage == "" ? LS("service_callback.label.incorrect_phone") : "\(validationMessage); \(LS("service_callback.label.incorrect_phone"))"
        //      }
        //      if let email = email where isValidEmail(email) {
        //        validationMessage = validationMessage == "" ? LS("service_callback.label.incorrect_email") : "\(validationMessage); \(LS("service_callback.label.incorrect_email"))"
        //      }
        //    }
        return isValid
    }
    
    var params: [String: AnyObject] {
        var resultParams: [String: AnyObject] = ["region": cityId!,
                                                 "region_type": "city",
                                                 "service_id": serviceId!,
                                                 "name": fullName!,
                                                 "phone": phone!,
                                                 "type": type!]
        if let email = email {
            resultParams["email"] = email
        }
        if let formType = formType {
            resultParams["form_type"] = formType
        }
        if let userComment = userComment {
            resultParams["user_comment"] = userComment
        }
        return resultParams as! [String : AnyObject]
    }
    
}
