//
//  ViewControllerWithMenu.swift
//  kt
//
//  Created by Alexandr Zalutskiy on 19.01.15.
//  Copyright (c) 2015 Alexandr Zalutskiy. All rights reserved.
//

import UIKit

func _orientationLandscape(orientation: UIDeviceOrientation) -> Bool {
    return (orientation == .LandscapeLeft) ||
        (orientation == .LandscapeRight)
}

@objc class ViewControllerWithMenu : KeyboardedViewController {
    
    var loadingIndicator : UIActivityIndicatorView?
    private let menuIcon = UIImage(named: "menu_icon")
    private let menuButton: UIButton
    
    func configureRightIndicator() {
        loadingIndicator = UIActivityIndicatorView(activityIndicatorStyle: .Gray)
        loadingIndicator!.hidesWhenStopped = true
        navigationItem.rightBarButtonItem = UIBarButtonItem(customView: loadingIndicator!)
    }
    
    required init?(coder aDecoder: NSCoder) {
        menuButton = UIButton(frame: CGRect(origin: CGPoint(x: 0, y: 0), size: menuIcon!.size))
        super.init(coder: aDecoder)
    }
    
    override init(nibName nibNameOrNil: String?, bundle nibBundleOrNil: NSBundle?) {
        menuButton = UIButton(frame: CGRect(origin: CGPoint(x: 0, y: 0), size: menuIcon!.size))
        super.init(nibName: nibNameOrNil, bundle: nibBundleOrNil)
    }
    
    override func viewDidLoad() {
        super.viewDidLoad()
        addMenuBarButton()
    }
    
    func addMenuBarButton() {
        menuButton.setImage(menuIcon, forState: .Normal)
        menuButton.setImage(UIImage(named: "menu_icon_highlighted"), forState: .Highlighted)
        menuButton.addTarget(self, action: #selector(ViewControllerWithMenu.menuButton_TouchUpInside(_:)), forControlEvents: UIControlEvents.TouchUpInside)
        self.navigationItem.leftBarButtonItem = UIBarButtonItem(customView: menuButton)
        if UIDevice.currentDevice().userInterfaceIdiom == .Pad {
            menuButton.enabled = !UIApplication.sharedApplication().statusBarOrientation.isLandscape
            menuButton.hidden = UIApplication.sharedApplication().statusBarOrientation.isLandscape
        }
        if UIApplication.sharedApplication().statusBarOrientation.isLandscape {
            menuButton.enabled = false
            menuButton.hidden = true
        } else {
            menuButton.enabled = true
            menuButton.hidden = false
        }
    }
    
    override func viewWillAppear(animated: Bool) {
        super.viewWillAppear(animated)
        if UIApplication.sharedApplication().statusBarOrientation.isLandscape {
            menuButton.enabled = false
            menuButton.hidden = true
        } else {
            menuButton.enabled = true
            menuButton.hidden = false
        }
    }
    
    func menuButton_TouchUpInside(sender: UIButton) {
        if let rvc = self.navigationController!.parentViewController! as? RootVC {
            rvc.openLeftSideViewControllerAnimated(true, completion: nil)
        } else if let rvc = self.navigationController!.parentViewController! as? MainViewController {
            let vc = rvc.parentViewController! as! RootVC
            vc.openLeftSideViewControllerAnimated(true, completion: nil)
        }
    }
    
    override func willAnimateRotationToInterfaceOrientation(toInterfaceOrientation: UIInterfaceOrientation, duration: NSTimeInterval) {
        super.willAnimateRotationToInterfaceOrientation(toInterfaceOrientation, duration: duration)
        if toInterfaceOrientation.isLandscape {
            menuButton.enabled = false
            menuButton.hidden = true
        } else {
            menuButton.enabled = true
            menuButton.hidden = false
        }
        let rvc = self.navigationController!.parentViewController! as! RootViewController
        rvc.closeSideViewControllerAnimated(false, completion: nil)
    }
}
