//
//  OfferCalbackRegionSelectViewController.swift
//  kt
//
//  Created by Assylkhan Rakhatov on 01.06.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//
//OfferCalbackRegionSelectViewController
import Foundation
import UIKit

@objc protocol RegionSelectViewControllerDelegate{
    optional func didSelectRegion(region: CallbackRegion, index: NSNumber)
}

class OfferCalbackRegionSelectViewController : UIViewController, UITableViewDataSource, UITableViewDelegate {
    @IBOutlet var tableView: UITableView!
    let reuseCellIdentifier = "cell"
    var regions: [CallbackRegion] = []
    var vc: OffersCallbackViewController?
    var serviceVC: ServiceCallbackController?
    var delegate : RegionSelectViewControllerDelegate?
    var type: String!
    var selectedRegion : CallbackRegion?
    
    
    override func viewDidLoad() {
        super.viewDidLoad()
        if serviceVC != nil {
            addBackButtonForModal(.whiteColor())
        } else {
            addBackButtonForDefault(.whiteColor())
        }
        configureBlueNavbar()
        configureTableView()
        
    }
    
    private func configureTableView() {
        tableView.rowHeight = UITableViewAutomaticDimension
        tableView.estimatedRowHeight = 60
    }
    
    override func viewWillAppear(animated: Bool) {
        super.viewWillAppear(animated)
        self.title = LS("registration.text_field.choose_city.placeholder");
        //    localize()
        tableView.reloadData()
    }
}


// UITableViewDataSource
extension OfferCalbackRegionSelectViewController {
    
    func tableView(tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        if let serviceVC = serviceVC {
            return serviceVC.regions.count
        }
        return regions.count
    }
    
    func tableView(tableView: UITableView, cellForRowAtIndexPath indexPath: NSIndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCellWithIdentifier(reuseCellIdentifier, forIndexPath: indexPath) as! OfferRegionCell
        if let serviceVC = serviceVC {
            cell.label.text = serviceVC.regions[indexPath.row].text
        } else {
            cell.fillCell(regions[indexPath.row].name!)
        }
        //cell.selectionStyle = .None
        return cell
    }
}

// UITableViewDelegate
extension OfferCalbackRegionSelectViewController {
    func tableView(tableView: UITableView, didSelectRowAtIndexPath indexPath: NSIndexPath) {
        if (delegate != nil) {
            var indexInt : Int = indexPath.row
            var index : NSNumber = NSNumber.init(integer: indexPath.row)
            delegate?.didSelectRegion!(regions[indexPath.row], index:index)
            //dismissViewControllerAnimated(false, completion: nil)
            back()
        }
        if (serviceVC == nil && vc == nil) {
            selectedRegion = regions[indexPath.row]
        } else {
            vc?.region = regions[indexPath.row]
            if let serviceVC = serviceVC {
                serviceVC.region = serviceVC.regions[indexPath.row]
                dismissViewControllerAnimated(false, completion: nil)
                
            } else {
                back()
            }
        }
    }
}

extension OfferCalbackRegionSelectViewController {
    override var localizedId: String {
        return "offers_callback_region_select"
    }
}
