//
//  LabeledCell.swift
//  kt
//
//  Created by Assylkhan Rakhatov on 15.05.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation
import UIKit

class LabeledCell: UITableViewCell {
  @IBOutlet weak var leftLabel: UILabel!
  @IBOutlet weak var rightLabel: UILabel!
  
  func fillCell(deviceSettings: DeviceSettings?, property: String) {
    leftLabel.textColor = Color.DarkColorForText
    rightLabel.textColor = Color.DarkColorForText
    leftLabel.localizeWithParent(self, localizedId: property)
    switch property {
    case "abonent_name":
      rightLabel.setTextAndSizeToFit(deviceSettings?.abonentName)
      break
    case "login":
      rightLabel.setTextAndSizeToFit(deviceSettings?.internetLogin)
      break
    case "credit_limit":
      rightLabel.setTextAndSizeToFit(deviceSettings?.limitInfo)
      break
    case "device":
      rightLabel.setTextAndSizeToFit(deviceSettings?.device)
      break
    case "turbo_mode":
      if let deviceSettings = deviceSettings {
        switch deviceSettings.turboInfo {
        case "-1":
          rightLabel.localizeWithParent(self, localizedId: "turned_on_but_cannot_access")
          break
        case "0":
          rightLabel.localizeWithParent(self, localizedId: "must_not_use")
          break
        case "1":
          rightLabel.localizeWithParent(self, localizedId: "turned_on")
          break
        case "2":
          rightLabel.localizeWithParent(self, localizedId: "turned_off")
          break
        default:
          break
        }
        break
      }
    default: break
    }
  }
}

extension LabeledCell : LocalizedParent {
  var localizedId:String {
    return "device_settings"
  }
}
