//
//  UITitleValueTableViewCell.swift
//  kt
//
//  Created by Admin on 05.12.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation

class ServerRegionCellData : TitleValueCellData {
    
    internal var serverItem : ServerItem? {
        didSet {
            self.value = serverItem!.name!
        }
    }
    
}

class TitleValueCellData : CellData {
    
    override internal var cellType: CellType { return CellType.TitleValueCell}
    var object : AnyObject?
    
    internal var title : String = "" {
        didSet {
            for (identifier, observer) in observers {
                if (identifier.compare("title") == .OrderedSame) {
                    observer(currentValue: title)
                }
            }
        }
    }
    
    internal var value : String = "" {
        didSet {
            for (identifier, observer) in observers {
                if (identifier.compare("value") == .OrderedSame) {
                    observer(currentValue: value)
                }
            }
            
        }
    }
    
    init(title: String, value: String) {
        super.init()
        self.title = title
        self.value = value
    }
    
    convenience init(title: String, value: String, onClick : () -> Void, onValidate:(AnyObject?) -> Bool) {
        self.init(title:title, value:value, onClick:onClick)
        self.onValidate = onValidate
    }
    
    
    convenience init(title: String, value: String, onClick : () -> Void) {
        self.init(title: title, value:value)
        self.onClick = onClick
    }
}

class UITitleValueTableViewCell : UIBaseTableViewCell {
    
    @IBOutlet weak var value: UILabel!
    @IBOutlet weak var title: UILabel!    
    
    
    override func fillWithCellData(cellData: CellData) {
        super.fillWithCellData(cellData)
        let titleValueCellData = cellData as! TitleValueCellData
        value.text = titleValueCellData.value
        title.text = titleValueCellData.title
        cellData.addObserver("title") { (currentValue) in
            self.title.text = currentValue
        }
        cellData.addObserver("value") { (currentValue) in
            self.value.text = currentValue
        }
    }
    
    
    
}
