//
//  CityLocation.swift
//  kt
//
//  Created by Alexandr Zalutskiy on 02.02.15.
//  Copyright (c) 2015 Alexandr Zalutskiy. All rights reserved.
//

import Foundation

class CallbackCity : CallbackPlaceProtocol {
	@objc var text : String
	@objc var id : Int
	
	init(text: String, id: Int) {
		self.text = text
		self.id = id
	}
}

class CallbackArea : CallbackPlaceProtocol {
	@objc var text : String
	@objc var id: Int
	
	init(text: String, id: Int) {
		self.text = text
		self.id = id
	}
}

class CallbackStreet : CallbackPlaceProtocol {
	@objc var text : String
	@objc var id: Int
	
	init(text: String, id: Int) {
		self.text = text
		self.id = id
	}
}

class CallbackHouse : CallbackPlaceProtocol {
	@objc var text : String
	@objc var id: Int
	
	init(text: String, id: Int) {
		self.text = text
		self.id = id
	}
}

class CityLocation: CallbackLocationProtocol {
	
	init(serviceId: Int) {
		self.serviceId = serviceId
	}
	
	var serviceId = 0
	
	private var callbackCity : CallbackCity?
	private var callbackArea : CallbackArea?
	private var callbackStreet : CallbackStreet?
	private var callbackHouse : CallbackHouse?
	
	var enableCallback : Bool {
		if (callbackHouse != nil) {
			return true
		}
		return false
	}
	
	func setInfo(info: CallbackPlaceProtocol, forRow row: Int) {
		switch row {
		case 0:
			callbackCity = info as? CallbackCity
			callbackArea = nil
			callbackStreet = nil
			callbackHouse = nil
		case 1:
			callbackArea = info as? CallbackArea
			callbackStreet = nil
			callbackHouse = nil
		case 2:
			callbackStreet = info as? CallbackStreet
			callbackHouse = nil
		case 3:
			callbackHouse = info as? CallbackHouse
		default:
			assert(true, "WTF!!!")
		}
	}
	
	func getInfoForRow(row: Int) -> (
		defaultSettings: (title: String, placeholder: String),
		info: CallbackPlaceProtocol?
		) {
			switch row {
			case 0:
				return (("ГОРОД", "Выберите город"), callbackCity)
			case 1:
				return (("РАЙОН", "Выберите район"), callbackArea)
			case 2:
				return (("УЛИЦА", "Выберите улицу"), callbackStreet)
			case 3:
				return (("ДОМ", "Выберите дом"), callbackHouse)
			default:
				assert(true, "WTF!!!")
				return (("", ""), nil)
			}
	}
	
	var currentCountOfCell: Int {
		if callbackStreet != nil {
			return 4
		} else if callbackArea != nil {
			return 3
		} else if callbackCity != nil {
			return 2
		}
		return 1
	}
	
	func routerForRow(row: Int) -> Router {
		switch row {
		case 0:
			return Router.CallbackServiceCities(serviceId)
		case 1:
			return Router.CallbackServiceCityAreas(serviceId, callbackCity!.id)
		case 2:
			return Router.CallbackServiceCityAreaStreets(serviceId, callbackCity!.id, callbackArea!.id)
		case 3:
			return Router.CallbackServiceCityAreaStreetHouses(
				serviceId,
				callbackCity!.id,
				callbackArea!.id,
				callbackStreet!.id
			)
		default:
			assert(true, "WTF!!!")
			return Router.CallbackServiceCities(serviceId)
		}
	}
}