//
//  ChangeInternetAccessPasswordRequest.swift
//  kt
//
//  Created by Assylkhan Rakhatov on 28.05.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation

class ChangeInternetAccessPasswordRequest {
  var accessToken: String?
  var clientId: String?
  var serverId: Int?
  var abonentId: String?
  var oldPassword: String?
  var newPassword: String?
  var newPasswordRepeat: String?
  
  init(accessToken: String, clientId: String, serverId: Int, abonentId: String, oldPassword: String?, newPassword: String?, newPasswordRepeat: String?) {
    self.accessToken = accessToken
    self.clientId = clientId
    self.serverId = serverId
    self.abonentId = abonentId
    self.oldPassword = oldPassword
    self.newPassword = newPassword
    self.newPasswordRepeat = newPasswordRepeat
  }
  
  func validateFields() -> Bool {
    var isValid = true
    if accessToken.isNilOrEmpty || clientId.isNilOrEmpty || serverId == nil || abonentId.isNilOrEmpty || oldPassword.isNilOrEmpty || newPassword.isNilOrEmpty || newPasswordRepeat.isNilOrEmpty {
      isValid = false
    }
    if oldPassword == "" || newPassword == "" || newPassword != newPasswordRepeat {
      isValid = false
    }
    return isValid
  }
  
  var params: [String: AnyObject] {
    return ["access_token": self.accessToken!,
            "client_id": self.clientId!,
            "server_id": self.serverId!,
            "abonent_id": self.abonentId!,
            "old_password": self.oldPassword ?? "",
            "new_password": self.newPassword ?? ""]
  }
}
