//
// Created by Alexander Zalutskiy on 10.08.15.
// Copyright (c) 2015 Alexandr Zalutskiy. All rights reserved.
//

import UIKit

struct CPanelDataTest: CPanelData {
  var name: String
  var hasActions: Bool
  var actionsTitles: [String]?
}

class CPanelViewController: ViewControllerWithCustomTitle {
  // MARK: Outlets

  @IBOutlet private weak var _tableView: UITableView!

  // MARK: Consts
  
  private let _cellReuseIdentifier = "cell"
  private let _headerReuseidentifier = "header"

  // MARK: Tests
  private let headers: [String] = [
      "MGL_IP_DSLAM 3787690",
      "ID TV 3787690",
      "Телефон 3787690",
      "SIP телефония 9711234",
  ]
  
  private let data: [CPanelDataTest] = [
      CPanelDataTest(name: "Служебный", hasActions: true,
          actionsTitles: ["История подключения", "Активные сессии", "Настройки", "Общественный Wi-Fi"]),
      CPanelDataTest(name: "ID TV", hasActions: false, actionsTitles: nil),
      CPanelDataTest(name: "Служебный", hasActions: false, actionsTitles: nil),
      CPanelDataTest(name: "Виртуальный номер iD Mobile ALTEL GSM", hasActions: false, actionsTitles: nil),
  ]

  // MARK: View life cycle

  override func viewDidLoad() {
    addBackButtonForDefault()
    navigationBarTitle = §"cpanel.title"

    _tableView.registerNib(UINib(nibName: "CPanelHeaderView", bundle: nil),
        forHeaderFooterViewReuseIdentifier: _headerReuseidentifier)
    _tableView.registerNib(UINib(nibName: "CPanelTableViewCell", bundle: nil),
        forCellReuseIdentifier: _cellReuseIdentifier)

    super.viewDidLoad()
  }


}

// MARK: - UITableViewDelegate
extension CPanelViewController: UITableViewDelegate {
  func tableView(tableView: UITableView, viewForHeaderInSection section: Int) -> UIView? {
    let view = tableView.dequeueReusableHeaderFooterViewWithIdentifier(_headerReuseidentifier) as! CPanelHeaderView
    view.setTitle(headers[section])
    return view
  }

  func tableView(tableView: UITableView, heightForHeaderInSection section: Int) -> CGFloat {
    return 53.0
  }

}

// MARK: - UITableViewDataSource
extension CPanelViewController: UITableViewDataSource {
  func numberOfSectionsInTableView(tableView: UITableView) -> Int {
    return 4
  }

  func tableView(tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
    return 1
  }

  func tableView(tableView: UITableView, cellForRowAtIndexPath indexPath: NSIndexPath) -> UITableViewCell {
    let cell = tableView.dequeueReusableCellWithIdentifier(_cellReuseIdentifier, forIndexPath: indexPath)
        as! CPanelTableViewCell

    cell.setData(data[indexPath.section])
//cell.selectionStyle = .None
    return cell
  }

}
