//
//  OffersSelectListViewController.swift
//  kt
//
//  Created by Assylkhan Rakhatov on 31.05.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation
import UIKit

class OffersSelectListViewController : UIViewController, UITableViewDataSource, UITableViewDelegate, UISearchBarDelegate {
  @IBOutlet var tableView: UITableView!
  @IBOutlet weak var searchBar: UISearchBar!
    
  let reuseCellIdentifier = "cell"
  var items: [[String]] = []
  var vc: OfferFormViewController?
  var type: String!
    var cellItems : [[String]] = []
    
  override func viewDidLoad() {
    super.viewDidLoad()
    cellItems = cellItemsFilterWithText("")
    //    addBackButtonForModal(.whiteColor())
    addBackButtonForDefault(.whiteColor())
    configureBlueNavbar()
    configureTableView()
  }
  
    public func getTextForItem(item : String) -> String {
        var result = ""
        switch item.lowercaseString {
        case "city", "village":
            result = LS("offer_form.label.\(item.lowercaseString)")
        default:
            result = item
        }
        return result
    }

    
    private func cellItemsFilterWithText(filterText : String) -> [[String]] {
        var result : [[String]] = []
        for item in items {
            let text = getTextForItem(item[1].uppercaseString)
            let index : String.Index = (text.characters.count >= filterText.characters.count) ? text.startIndex.advancedBy(filterText.characters.count) : text.startIndex.advancedBy(text.characters.count)
            let cleandText = text.substringToIndex(index)
            if (cleandText.uppercaseString.containsString(filterText.uppercaseString) || filterText.characters.count == 0) {
                result.append(item)
            }
        }
        return result
    }
    
  private func configureTableView() {
    tableView.bounces = false
    
    tableView.rowHeight = UITableViewAutomaticDimension
    tableView.estimatedRowHeight = 60
  }
  
  override func viewWillAppear(animated: Bool) {
    super.viewWillAppear(animated)
    //    localize()
    tableView.reloadData()
  }
}

// UITableViewDataSource
extension OffersSelectListViewController {
  
  func tableView(tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
    return cellItems.count//items.count
  }
  
  func tableView(tableView: UITableView, cellForRowAtIndexPath indexPath: NSIndexPath) -> UITableViewCell {
    let cell = tableView.dequeueReusableCellWithIdentifier(reuseCellIdentifier, forIndexPath: indexPath) as! OfferSelectCell
    cell.fillCell(getTextForItem(cellItems[indexPath.row][1]))//(items[indexPath.row][1])
    //cell.selectionStyle = .None
    return cell
  }
}

extension OffersSelectListViewController {
    func searchBar(searchBar: UISearchBar, textDidChange searchText: String) {
        cellItems = cellItemsFilterWithText(searchText)
        tableView.reloadData()
    }
}

// UITableViewDelegate
extension OffersSelectListViewController {
  func tableView(tableView: UITableView, didSelectRowAtIndexPath indexPath: NSIndexPath) {
    switch type {
    case "point_type":
      vc?.pointType = cellItems[indexPath.row][1]
      break
    case "your_city":
      vc?.cityId = cellItems[indexPath.row][0]
      break
    case "region":
      vc?.regionId = cellItems[indexPath.row][0]
      break
    case "area":
      vc?.areaId = cellItems[indexPath.row][0]
      break
    case "village":
      vc?.villageId = cellItems[indexPath.row][0]
      break
    case "street":
      vc?.streetId = cellItems[indexPath.row][0]
      break
    case "house":
      vc?.houseId = cellItems[indexPath.row][0]
      break
    default: break
    }
    self.navigationController?.popViewControllerAnimated(true)
    //    self.vc?.dismissViewControllerAnimated(false, completion: nil)
  }
}

extension OffersSelectListViewController {
  override var localizedId: String {
    return "offers_select_list"
  }
}
