//
//  ServiceMainViewController.swift
//  kt
//
//  Created by neox on 29.06.17.
//  Copyright © 2017 SimpleCode. All rights reserved.
//

import UIKit

class ServiceMainViewController: ViewControllerWithMenu {
    
    var selectedIndexPath: NSIndexPath?
    
    @IBOutlet weak var tableView: UITableView!
    
    override func viewDidLoad() {
        self.navigationItem.title = "Пакеты"
        super.viewDidLoad()
    }
    
    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
    }
    
    override func viewWillAppear(animated: Bool) {
        super.viewWillAppear(animated)
        configureBlueNavbar()
    }
}

// UITableViewDataSource
extension ServiceMainViewController {
    
    func tableView(tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return DynamicMenuManager.sharedInstance().menu.count
    }
    
    func tableView(tableView: UITableView, cellForRowAtIndexPath indexPath: NSIndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCellWithIdentifier("cell", forIndexPath: indexPath) as! ServiceMainCell
        cell.name.text = DynamicMenuManager.sharedInstance().menu[indexPath.row]["name"] as! String
        return cell
    }
    
}

// UITableViewDelegate
extension ServiceMainViewController {
    
    func tableView(tableView: UITableView, didSelectRowAtIndexPath indexPath: NSIndexPath) {
        self.selectedIndexPath = indexPath
        let nvc = storyboard!.instantiateViewControllerWithIdentifier("ServiceListController") as! ServiceListController
        nvc.selectedIndex = selectedIndexPath!.row
        self.navigationController?.pushViewController(nvc, animated: true)
    }
}
