//
//  NSDate+format.swift
//  kt
//
//  Created by Assylkhan Rakhatov on 22.05.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation

extension NSDate {
  
  func myDateByAddingDays(daysCount: Int) -> NSDate {
    //    let day:Double = 60*60*24
    //    return self.dateByAddingTimeInterval(Double(daysCount) * day)
    return NSCalendar.currentCalendar().dateByAddingUnit(.Day, value: daysCount, toDate: NSDate(), options: NSCalendarOptions(rawValue: 0))!
  }
  
//  let sevenDaysAgo = NSCalendar.currentCalendar().dateByAddingUnit(.Day, value: -7,
//                                                                   toDate: NSDate(), options: NSCalendarOptions(rawValue: 0))
  
  func getComponents(units: NSCalendarUnit = [.Day, .Month, .Year]) -> NSDateComponents {
    let calendar = NSCalendar.currentCalendar()
    let components = calendar.components(units, fromDate: self)
    return components
  }
  
  func isEqualByComponents(date: NSDate, units: NSCalendarUnit = [.Day, .Month, .Year]) -> Bool {
    let calendar = NSCalendar.currentCalendar()
    let components1 = calendar.components(units, fromDate: self)
    let components2 = calendar.components(units, fromDate: date)
    let year1 =  components1.year
    let month1 = components1.month
    let year2 =  components2.year
    let month2 = components2.month
    
    return year1 == year2 && month1 == month2
  }
  
  func getWithFormat(format: String) -> String {
    let dateFormatter = NSDateFormatter()
    dateFormatter.locale = NSLocale(localeIdentifier: "en_US_POSIX")
    dateFormatter.dateFormat = format
    return dateFormatter.stringFromDate(self)
  }
  
  func yearsFrom(date:NSDate) -> Int{
    return NSCalendar.currentCalendar().components(.Year, fromDate: date, toDate: self, options: []).year
  }
  func monthsFrom(date:NSDate) -> Int{
    return NSCalendar.currentCalendar().components(.Month, fromDate: date, toDate: self, options: []).month
  }
  func weeksFrom(date:NSDate) -> Int{
    return NSCalendar.currentCalendar().components(.WeekOfYear, fromDate: date, toDate: self, options: []).weekOfYear
  }
  func daysFrom(date:NSDate) -> Int{
    return NSCalendar.currentCalendar().components(.Day, fromDate: date, toDate: self, options: []).day
  }
  func hoursFrom(date:NSDate) -> Int{
    return NSCalendar.currentCalendar().components(.Hour, fromDate: date, toDate: self, options: []).hour
  }
  func minutesFrom(date:NSDate) -> Int{
    return NSCalendar.currentCalendar().components(.Minute, fromDate: date, toDate: self, options: []).minute
  }
  func secondsFrom(date:NSDate) -> Int{
    return NSCalendar.currentCalendar().components(.Second, fromDate: date, toDate: self, options: []).second
  }
  
  func offsetFrom(date:NSDate) -> String {
    if yearsFrom(date)   > 0 { return "\(yearsFrom(date))y"   }
    if monthsFrom(date)  > 0 { return "\(monthsFrom(date))M"  }
    if weeksFrom(date)   > 0 { return "\(weeksFrom(date))w"   }
    if daysFrom(date)    > 0 { return "\(daysFrom(date))d"    }
    if hoursFrom(date)   > 0 { return "\(hoursFrom(date))h"   }
    if minutesFrom(date) > 0 { return "\(minutesFrom(date))m" }
    if secondsFrom(date) > 0 { return "\(secondsFrom(date))s" }
    return ""
  }
  
}
